/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.soap.BaseWebService;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.composer.MessageComposer;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.DeliveryException;
import org.w3c.dom.Node;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String MESSAGE_NAME = "MESSAGE_NAME";
    private static final String WSDL_LOCATION = "javax.xml.ws.wsdl.description";
    private final SOAPBindingModel _config;
    private final MessageComposer<SOAPMessage> _messageComposer;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private long _waitTimeout = 15000L;
    private Endpoint _endpoint;
    private Port _wsdlPort;
    private String _scheme = "http";

    public InboundHandler(SOAPBindingModel config, ServiceDomain domain) {
        this._config = config;
        this._domain = domain;
        this._messageComposer = SOAPComposition.getMessageComposer((BindingModel)config);
    }

    public void start() throws WebServicePublishException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            this._service = this._domain.getServiceReference(this._config.getServiceName());
            PortName portName = this._config.getPort();
            Service wsdlService = WSDLUtil.getService(this._config.getWsdl(), portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
            portName.setServiceQName(wsdlService.getQName());
            portName.setName(this._wsdlPort.getName());
            BaseWebService wsProvider = new BaseWebService();
            wsProvider.setInvocationClassLoader(Thread.currentThread().getContextClassLoader());
            wsProvider.setConsumer(this);
            ArrayList<StreamSource> metadata = new ArrayList<StreamSource>();
            StreamSource source = WSDLUtil.getStream(this._config.getWsdl());
            metadata.add(source);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("javax.xml.ws.wsdl.service", portName.getServiceQName());
            properties.put("javax.xml.ws.wsdl.port", portName.getPortQName());
            properties.put(WSDL_LOCATION, WSDLUtil.getURL(this._config.getWsdl()).toExternalForm());
            String path = "/" + portName.getServiceName();
            if (this._config.getContextPath() != null) {
                path = "/" + this._config.getContextPath() + "/" + portName.getServiceName();
            }
            String publishUrl = this._scheme + "://" + this._config.getSocketAddr().getHost() + ":" + this._config.getSocketAddr().getPort() + path;
            LOGGER.info((Object)("Publishing WebService at " + publishUrl));
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this._endpoint = Endpoint.create((Object)wsProvider);
            this._endpoint.setMetadata(metadata);
            this._endpoint.setProperties(properties);
            this._endpoint.publish(publishUrl);
        }
        catch (MalformedURLException e) {
            throw new WebServicePublishException(e);
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    public void stop() {
        this._endpoint.stop();
        LOGGER.info((Object)("WebService " + this._config.getPort() + " stopped."));
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }

    public SOAPMessage invoke(SOAPMessage soapMessage) {
        Operation operation;
        String operationName = null;
        Boolean oneWay = false;
        String firstBodyElement = null;
        if (soapMessage == null || soapMessage.getSOAPPart() == null) {
            return this.handleException(oneWay, new SOAPException("No such operation: " + this._wsdlPort.getName() + "->null"));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Request:[" + SOAPUtil.soapMessageToString(soapMessage) + "]"));
        }
        try {
            firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
            operation = WSDLUtil.getOperation(this._wsdlPort, firstBodyElement);
            if (operation != null) {
                operationName = operation.getName();
                oneWay = WSDLUtil.isOneWay(operation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Received SOAP message targeted at Webservice operation '" + operationName + "' on port '" + this._wsdlPort.getName() + "'."));
                }
            }
        }
        catch (SOAPException e) {
            LOGGER.error((Object)e);
            return null;
        }
        if (operation == null) {
            return this.handleException(oneWay, new SOAPException("Operation for '" + firstBodyElement + "' not available on target Service '" + this._service.getName() + "'."));
        }
        try {
            SOAPMessage soapResponse;
            Message message;
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._service.createExchange(operationName, (ExchangeHandler)inOutHandler);
            try {
                message = this._messageComposer.compose((Object)soapMessage, exchange, true);
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            this.assertComposedMessageOK(message, operation);
            exchange.getContext().setProperty(MESSAGE_NAME, (Object)operation.getInput().getMessage().getQName().getLocalPart(), Scope.IN);
            if (oneWay.booleanValue()) {
                exchange.send(message);
                return null;
            }
            exchange.send(message);
            try {
                exchange = inOutHandler.waitForOut(this._waitTimeout);
            }
            catch (DeliveryException e) {
                return this.handleException(oneWay, new SOAPException("Timed out after " + this._waitTimeout + " ms waiting on synchronous response from target service '" + this._service.getName() + "'."));
            }
            if (SOAPUtil.SOAP_MESSAGE_FACTORY == null) {
                throw new SOAPException("Failed to instantiate SOAP Message Factory");
            }
            try {
                soapResponse = (SOAPMessage)this._messageComposer.decompose(exchange, (Object)SOAPUtil.SOAP_MESSAGE_FACTORY.createMessage());
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            if (exchange.getState() == ExchangeState.FAULT && soapResponse.getSOAPBody().getFault() == null) {
                return this.handleException(oneWay, new SOAPException("Invalid response SOAPMessage construction.  The associated SwitchYard Exchange is in a FAULT state, but the SOAPMessage is not a Fault message.  The MessageComposer implementation in use (" + this._messageComposer.getClass().getName() + ") must generate the SOAPMessage instance properly as a Fault message."));
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Response:[" + SOAPUtil.soapMessageToString(soapResponse) + "]"));
            }
            return soapResponse;
        }
        catch (SOAPException se) {
            return this.handleException(oneWay, se);
        }
    }

    private void assertComposedMessageOK(Message soapMessage, Operation operation) throws SOAPException {
        Node inputMessage = (Node)soapMessage.getContent(Node.class);
        if (inputMessage == null) {
            throw new SOAPException("Composer created a null ESB Message payload for service '" + this._service.getName() + "'.  Must be of type '" + SOAPMessage.class.getName() + "'.");
        }
        String actualNS = inputMessage.getNamespaceURI();
        String actualLN = inputMessage.getLocalName();
        List parts = operation.getInput().getMessage().getOrderedParts(null);
        if (parts.isEmpty()) {
            throw new SOAPException("Invalid input SOAP payload for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  No such Part '" + actualLN + "'.");
        }
        Part part = (Part)parts.get(0);
        QName expectedPayloadType = part.getElementName();
        String expectedNS = expectedPayloadType.getNamespaceURI();
        String expectedLN = expectedPayloadType.getLocalPart();
        if (expectedNS != null && !expectedNS.equals(actualNS)) {
            throw new SOAPException("Invalid input SOAP payload namespace for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation namespace as '" + expectedNS + "'.  Actual namespace on input SOAP message '" + actualNS + "'.");
        }
        if (expectedLN != null && !expectedLN.equals(actualLN)) {
            throw new SOAPException("Invalid input SOAP payload localNamePart for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation localNamePart as '" + expectedLN + "'.  Actual localNamePart on input SOAP message '" + actualLN + "'.");
        }
    }

    private SOAPMessage handleException(Boolean oneWay, SOAPException se) {
        if (oneWay.booleanValue()) {
            LOGGER.error((Object)se);
        } else {
            try {
                return SOAPUtil.generateFault(se);
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
        return null;
    }
}

