/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.util.Iterator;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.composer.BaseMessageComposer;

public class SOAPMessageComposer
extends BaseMessageComposer<SOAPMessage> {
    public Message compose(SOAPMessage source, Exchange exchange, boolean create) throws Exception {
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        this.getContextMapper().mapFrom((Object)source, exchange.getContext());
        SOAPBody soapBody = source.getSOAPBody();
        if (soapBody == null) {
            throw new SOAPException("Missing SOAP body from request");
        }
        Iterator children = soapBody.getChildElements();
        boolean found = false;
        try {
            while (children.hasNext()) {
                Node node = (Node)children.next();
                if (!(node instanceof SOAPElement)) continue;
                if (found) {
                    throw new SOAPException("Found multiple SOAPElements in SOAPBody");
                }
                node.detachNode();
                message.setContent((Object)new DOMSource((org.w3c.dom.Node)node));
                found = true;
            }
        }
        catch (Exception ex) {
            if (ex instanceof SOAPException) {
                throw (SOAPException)ex;
            }
            throw new SOAPException((Throwable)ex);
        }
        if (!found) {
            throw new SOAPException("Could not find SOAPElement in SOAPBody");
        }
        return message;
    }

    public SOAPMessage decompose(Exchange exchange, SOAPMessage target) throws Exception {
        Message message = exchange.getMessage();
        if (message != null) {
            if (message.getContent() == null) {
                throw new SOAPException("Null response from service");
            }
            if (message.getContent() instanceof SOAPMessage) {
                return (SOAPMessage)message.getContent();
            }
            org.w3c.dom.Node input = (org.w3c.dom.Node)message.getContent(org.w3c.dom.Node.class);
            try {
                org.w3c.dom.Node messageNodeImport = target.getSOAPBody().getOwnerDocument().importNode(input, true);
                if (exchange.getState() != ExchangeState.FAULT || this.isSOAPFaultPayload(input)) {
                    target.getSOAPBody().appendChild(messageNodeImport);
                } else {
                    target.getSOAPBody().addFault(SOAPUtil.SERVER_FAULT_QN, "Send failed").addDetail().appendChild(messageNodeImport);
                }
            }
            catch (Exception e) {
                throw new SOAPException("Unable to parse SOAP Message", (Throwable)e);
            }
        }
        this.getContextMapper().mapTo(exchange.getContext(), (Object)target);
        return target;
    }

    private boolean isSOAPFaultPayload(org.w3c.dom.Node messageNode) {
        String nsURI;
        String rootName = messageNode.getLocalName().toLowerCase();
        return rootName.equals("fault") && "http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI = messageNode.getNamespaceURI());
    }
}

