/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.junit.Assert;
import org.switchyard.test.SwitchYardTestCaseConfig;
import org.switchyard.test.mixins.CDIMixIn;

public class MockInitialContextFactory
implements InitialContextFactory {
    protected static final NameParser NAME_PARSER = new NameParser(){

        @Override
        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    };
    private static Map<ClassLoader, Context> _contexts = new HashMap<ClassLoader, Context>();

    public static void install() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
        }
        try {
            MockInitialContextFactory.createContextForTCCL();
        }
        catch (NamingException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to create context for TCCL: " + e.getMessage()));
        }
    }

    public static void clear() {
        _contexts.clear();
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return MockInitialContextFactory.createContextForTCCL();
    }

    public static Context getJavaComp() throws NamingException {
        return MockInitialContextFactory.getSubContext("java:comp");
    }

    public static Context getSubContext(String name) throws NamingException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Context context = _contexts.get(tccl);
        if (context == null) {
            Assert.fail((String)"No global namespace context bound for current test Thread.");
        }
        return (Context)context.lookup(name);
    }

    private static Context createContextForTCCL() throws NamingException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Context context = _contexts.get(tccl);
        if (context == null) {
            context = (Context)Proxy.newProxyInstance(Context.class.getClassLoader(), new Class[]{Context.class}, (InvocationHandler)new ContextInvocationHandler());
            _contexts.put(tccl, context);
            context.createSubcontext("java:comp");
        }
        return context;
    }

    static class ContextInvocationHandler
    implements InvocationHandler {
        private Map<Object, Object> _boundObjects = new HashMap<Object, Object>();

        ContextInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("bind") && args.length == 2) {
                this._boundObjects.put(args[0], args[1]);
                return null;
            }
            if (methodName.equals("rebind") && args.length == 2) {
                this._boundObjects.put(args[0], args[1]);
                return null;
            }
            if (methodName.equals("unbind") && args.length == 1) {
                this._boundObjects.remove(args[0]);
                return null;
            }
            if (methodName.equals("lookup") && args.length == 1) {
                Object object = this._boundObjects.get(args[0]);
                if (object != null) {
                    return object;
                }
                this.tryHelpDeveloper(args[0]);
                throw new NamingException("Unknown object name '" + args[0] + "'.");
            }
            if (methodName.equals("createSubcontext")) {
                Object name = args[0];
                if (this._boundObjects.containsKey(name)) {
                    throw new NamingException("Subcontext '" + name + "' already exists.");
                }
                Context subContext = (Context)Proxy.newProxyInstance(Context.class.getClassLoader(), new Class[]{Context.class}, (InvocationHandler)new ContextInvocationHandler());
                this._boundObjects.put(name, subContext);
                return subContext;
            }
            if (methodName.equals("destroySubcontext")) {
                Object name = args[0];
                if (!this._boundObjects.containsKey(name)) {
                    throw new NamingException("Subcontext '" + name + "' doesn't exists.");
                }
                this._boundObjects.remove(name);
                return null;
            }
            if (methodName.equals("getNameParser")) {
                return NAME_PARSER;
            }
            if (methodName.equals("close")) {
                return true;
            }
            throw new NamingException("Unexpected call to '" + method.getName() + "'.");
        }

        private void tryHelpDeveloper(Object objectName) {
            if (objectName.equals("BeanManager")) {
                Assert.fail((String)("Your test requires access to the CDI BeanManager.  You need to annotate your test class with '@" + SwitchYardTestCaseConfig.class.getSimpleName() + "(mixins = " + CDIMixIn.class.getSimpleName() + ".class)'"));
            }
        }
    }
}

