/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins.jca;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.deployer.MainDeployer;
import com.github.fungal.spi.deployers.Deployer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.fungal.AbstractFungalDeployment;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.RADeployer;
import org.jboss.jca.embedded.Embedded;
import org.jboss.jca.embedded.EmbeddedFactory;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;

public class SwitchYardIronJacamarHandler {
    private final Embedded _embedded;
    private Kernel _kernel;
    private MainDeployer _mainDeployer;
    private ResourceAdapterRepository _resourceAdapterRepository;
    private List<ResourceAdapterArchive> _deployments = new ArrayList<ResourceAdapterArchive>();

    public SwitchYardIronJacamarHandler() throws Exception {
        this._embedded = EmbeddedFactory.create();
    }

    public void startup() throws Throwable {
        this._embedded.startup();
        this._kernel = this.getFieldValue(this._embedded, Kernel.class, "kernel");
        this._mainDeployer = this._kernel.getMainDeployer();
    }

    public void deploy(ResourceAdapterArchive raa) throws Throwable {
        this._embedded.deploy(raa);
        this._deployments.add(raa);
    }

    public void shutdown() throws Throwable {
        for (ResourceAdapterArchive raa : this._deployments) {
            this._embedded.undeploy(raa);
        }
        this._embedded.shutdown();
        this._kernel = null;
        this._mainDeployer = null;
    }

    public Embedded getEmbeddedInstance() {
        return this._embedded;
    }

    public ResourceAdapterRepository getResourceAdapterRepository() throws Exception {
        if (this._resourceAdapterRepository != null) {
            return this._resourceAdapterRepository;
        }
        Object deployers = this.getFieldValue(this._mainDeployer, Object.class, "deployers");
        Method getDeployersMethod = deployers.getClass().getDeclaredMethod("getDeployers", new Class[0]);
        getDeployersMethod.setAccessible(true);
        List deployerList = (List)getDeployersMethod.invoke(deployers, new Object[0]);
        getDeployersMethod.setAccessible(false);
        RADeployer radeployer = null;
        for (Deployer deployer : deployerList) {
            if (!(deployer instanceof RADeployer)) continue;
            radeployer = (RADeployer)RADeployer.class.cast(deployer);
            break;
        }
        this._resourceAdapterRepository = ((RAConfiguration)radeployer.getConfiguration()).getResourceAdapterRepository();
        return this._resourceAdapterRepository;
    }

    public String getResourceAdapterIdentifier(String raName) throws Exception {
        List deployments = this.getFieldValue(this._kernel, List.class, "deployments");
        for (Object deploy : deployments) {
            if (!(deploy instanceof AbstractFungalDeployment) || !this.getFieldValue(deploy, Boolean.TYPE, "activator").booleanValue() || !this.getFieldValue(deploy, String.class, "deploymentName").equals(raName)) continue;
            return this.getFieldValue(deploy, String.class, "raKey");
        }
        return null;
    }

    private <T> T getFieldValue(Object target, Class<T> type, String name) throws Exception {
        for (Class<?> targetClass = target.getClass(); targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            try {
                Field f = targetClass.getDeclaredField(name);
                if (type != Object.class && !f.getType().isAssignableFrom(type)) continue;
                f.setAccessible(true);
                Object val = f.get(target);
                f.setAccessible(false);
                return (T)val;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return null;
    }
}

