/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt.internal;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import org.jboss.logging.Logger;

public class TransformerPool {
    private Logger _logger = Logger.getLogger(TransformerPool.class);
    private BlockingQueue<Transformer> _pool;
    private Templates _templates;
    private AtomicInteger _count = new AtomicInteger(0);
    private int _maxSize;
    private ErrorListener _errorListener;

    public TransformerPool(Templates templates, int maxSize) {
        this(templates, maxSize, null);
    }

    public TransformerPool(Templates templates, int maxSize, ErrorListener errorListener) {
        this._templates = templates;
        this._maxSize = maxSize;
        this._errorListener = errorListener;
        this._pool = new ArrayBlockingQueue<Transformer>(maxSize, true);
    }

    public Transformer take() throws Exception {
        Transformer t = (Transformer)this._pool.poll();
        if (t != null) {
            return t;
        }
        if (this._count.get() < this._maxSize) {
            this.addTransformer();
        }
        return this._pool.take();
    }

    public boolean give(Transformer transformer) {
        return this._pool.offer(transformer);
    }

    private void addTransformer() throws Exception {
        Transformer transformer = this._templates.newTransformer();
        if (this._errorListener != null) {
            transformer.setErrorListener(this._errorListener);
        }
        this._count.incrementAndGet();
        boolean result = this._pool.offer(transformer);
        if (!result && this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Unable to add " + transformer.toString() + " to blocking queue"));
        }
    }
}

