package syncloud.dao;

import syncloud.core.CoreException;
import syncloud.core.log.Logger;

public class DaoFactory {
    private static Logger logger = Logger.getLogger(DaoFactory.class);
    public static final String MESSAGE = "Can't create IStateDao instance";
    public static final String CLASS_NAME = "syncloud.dao.sqljet.StateDao";

    public static IStateDao State() {
        try {
            if(System.getProperty("java.vm.name").equalsIgnoreCase("Dalvik")){
                return null;
            } else {
                Class stateDaoClass = Class.forName(CLASS_NAME);
                IStateDao stateDao = (IStateDao)stateDaoClass.newInstance();
                return stateDao;
            }
        } catch (ClassNotFoundException e) {
            logger.error(MESSAGE, e);
            throw new CoreException(MESSAGE, e);
        } catch (InstantiationException e) {
            logger.error(MESSAGE, e);
            throw new CoreException(MESSAGE, e);
        } catch (IllegalAccessException e) {
            logger.error(MESSAGE, e);
            throw new CoreException(MESSAGE, e);
        }

    }
}
