package syncloud.dao;

public class State {
    public String fullname;
    public String version;

    public State(String fullname, String version) {
        this.fullname = fullname;
        this.version = version;
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State otherState = (State) obj;

            boolean sameFullname = this.fullname.equals(otherState.fullname);
            boolean sameVersion =
                    (this.version == null && otherState.version == null) ||
                    (this.version != null && this.version.equals(otherState.version));

            return sameFullname && sameVersion;
        }
        return false;
    }

    @Override
    public String toString() {
        return "State{" +
                "fullname='" + fullname + '\'' +
                ", version='" + version + '\'' +
                '}';
    }
}
