/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.client.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.syncope.client.validation.SyncopeClientException;
import org.syncope.types.SyncopeClientExceptionType;

public class SyncopeClientCompositeErrorException
extends HttpClientErrorException {
    private Set<SyncopeClientException> exceptions = new HashSet<SyncopeClientException>();

    public SyncopeClientCompositeErrorException(HttpStatus statusCode) {
        super(statusCode);
    }

    public boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    public boolean hasException(SyncopeClientExceptionType exceptionType) {
        return this.getException(exceptionType) != null;
    }

    public SyncopeClientException getException(SyncopeClientExceptionType exceptionType) {
        boolean found = false;
        SyncopeClientException syncopeClientException = null;
        Iterator<SyncopeClientException> itor = this.exceptions.iterator();
        while (itor.hasNext() && !found) {
            syncopeClientException = itor.next();
            if (!syncopeClientException.getType().equals((Object)exceptionType)) continue;
            found = true;
        }
        return found ? syncopeClientException : null;
    }

    public Set<SyncopeClientException> getExceptions() {
        return this.exceptions;
    }

    public boolean addException(SyncopeClientException exception) {
        if (exception.getType() == null) {
            throw new IllegalArgumentException(exception + " does not have the right " + SyncopeClientExceptionType.class.getName() + " set");
        }
        return this.exceptions.add(exception);
    }

    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append("{");
        for (SyncopeClientException e : this.getExceptions()) {
            message.append("[");
            message.append((Object)e.getType());
            message.append(" ");
            message.append(e.getElements());
            message.append("], ");
        }
        message.append("}");
        return message.toString();
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

