/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.client.validation;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.client.validation.SyncopeClientException;
import org.syncope.types.SyncopeClientExceptionType;

public class SyncopeClientErrorHandler
extends DefaultResponseErrorHandler {
    public static final String EXCEPTION_TYPE_HEADER = "ExceptionType";
    private static final Logger log = LoggerFactory.getLogger(SyncopeClientErrorHandler.class);
    public static final HttpStatus[] managedStatuses = new HttpStatus[]{HttpStatus.BAD_REQUEST, HttpStatus.NOT_FOUND};

    public void handleError(ClientHttpResponse response) throws IOException {
        if (!ArrayUtils.contains((Object[])managedStatuses, (Object)response.getStatusCode())) {
            super.handleError(response);
        }
        SyncopeClientCompositeErrorException compositeException = new SyncopeClientCompositeErrorException(response.getStatusCode());
        List exceptionTypesInHeaders = response.getHeaders().get((Object)EXCEPTION_TYPE_HEADER);
        if (exceptionTypesInHeaders == null) {
            if (log.isDebugEnabled()) {
                log.debug("No ExceptionType provided");
            }
            return;
        }
        SyncopeClientExceptionType exceptionType = null;
        SyncopeClientException clientException = null;
        HashSet<String> handledExceptions = new HashSet<String>();
        for (String exceptionTypeAsString : exceptionTypesInHeaders) {
            try {
                exceptionType = SyncopeClientExceptionType.getFromHeaderValue(exceptionTypeAsString);
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected value of ExceptionType: " + exceptionTypeAsString, (Throwable)e);
            }
            if (exceptionType == null) continue;
            handledExceptions.add(exceptionTypeAsString);
            clientException = new SyncopeClientException();
            clientException.setType(exceptionType);
            if (response.getHeaders().get((Object)exceptionType.getElementHeaderName()) != null && !response.getHeaders().get((Object)exceptionType.getElementHeaderName()).isEmpty()) {
                clientException.setElements(response.getHeaders().get((Object)exceptionType.getElementHeaderName()));
            }
            compositeException.addException(clientException);
        }
        exceptionTypesInHeaders.removeAll(handledExceptions);
        if (!exceptionTypesInHeaders.isEmpty()) {
            log.error("Unmanaged exceptions: " + exceptionTypesInHeaders);
        }
        if (compositeException.hasExceptions()) {
            throw compositeException;
        }
    }
}

