/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.types;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public enum SchemaValueType {
    String("java.lang.String"),
    Long("java.lang.Long"),
    Double("java.lang.Double"),
    Boolean("java.lang.Boolean"),
    Date("java.util.Date");

    private final String className;
    private Format formatter;

    private SchemaValueType(String className) {
        this.className = className;
        this.formatter = null;
    }

    public String getClassName() {
        return this.className;
    }

    public Format getBasicFormatter() {
        if (this.formatter == null) {
            switch (this) {
                case Date: {
                    this.formatter = new SimpleDateFormat();
                    break;
                }
                case Long: 
                case Double: {
                    this.formatter = new DecimalFormat();
                }
            }
        }
        return this.formatter;
    }

    public boolean isConversionPatternNeeded() {
        return this == Date || this == Double || this == Long;
    }
}

