/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.teamapps.protocol.system.SystemLogEntry;
import org.teamapps.universaldb.UniversalDB;

public class DatabaseLogAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    public static final ThreadLocal<Integer> THREAD_LOCAL_MANAGED_APPLICATION = new ThreadLocal();
    public static final ThreadLocal<String> THREAD_LOCAL_APPLICATION_VERSION = new ThreadLocal();
    public static final ThreadLocal<Integer> THREAD_LOCAL_MANAGED_PERSPECTIVE = new ThreadLocal();
    private static boolean started = false;

    public static void startLogger() {
        started = true;
    }

    private int getManagedApplicationId() {
        Integer applicationId = THREAD_LOCAL_MANAGED_APPLICATION.get();
        return applicationId != null ? applicationId : 0;
    }

    private int getManagedPerspectiveId() {
        Integer perspectiveId = THREAD_LOCAL_MANAGED_PERSPECTIVE.get();
        return perspectiveId != null ? perspectiveId : 0;
    }

    protected void append(ILoggingEvent event) {
        int logLevel = this.getLogLevel(event);
        if (!started || logLevel == 0) {
            return;
        }
        if (event.getMarker() != null && UniversalDB.SKIP_DB_LOGGING.getName().equals(event.getMarker().getName())) {
            return;
        }
        int userId = UniversalDB.getUserId();
        int managedApplicationId = this.getManagedApplicationId();
        int managedPerspectiveId = this.getManagedPerspectiveId();
        String applicationVersion = THREAD_LOCAL_APPLICATION_VERSION.get();
        String threadName = event.getThreadName();
        String message = event.getFormattedMessage();
        String exceptionClass = null;
        String stackTrace = null;
        if (event.getThrowableProxy() != null) {
            exceptionClass = event.getThrowableProxy().getClassName();
            stackTrace = ThrowableProxyUtil.asString((IThrowableProxy)event.getThrowableProxy());
        }
        SystemLogEntry logEntry = new SystemLogEntry().setTimestamp(System.currentTimeMillis()).setUserId(userId).setManagedApplicationId(managedApplicationId).setManagedApplicationPerspectiveId(managedPerspectiveId).setApplicationVersion(applicationVersion).setThreadName(threadName).setMessage(message);
        if (stackTrace != null) {
            logEntry.setExceptionClass(exceptionClass).setStackTrace(stackTrace);
        }
    }

    private int getLogLevel(ILoggingEvent event) {
        Level level = event.getLevel();
        if (Level.DEBUG == level) {
            return 1;
        }
        if (Level.INFO == level) {
            return 2;
        }
        if (Level.WARN == level) {
            return 3;
        }
        if (Level.ERROR == level) {
            return 4;
        }
        return 0;
    }
}

