/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.teamapps.application.api.application.entity.EntityUpdate;
import org.teamapps.application.api.application.entity.EntityUpdateType;
import org.teamapps.event.Event;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.universaldb.update.RecordUpdateEvent;
import org.teamapps.ux.session.SessionContext;

public class EntityUpdateEventHandler
extends Thread {
    private final ArrayBlockingQueue<RecordUpdateEvent> updateQueue;
    private final ConcurrentHashMap<Integer, TableEventHandler> tableEventHandlerByTableId = new ConcurrentHashMap();

    public EntityUpdateEventHandler(ArrayBlockingQueue<RecordUpdateEvent> updateQueue) {
        this.updateQueue = updateQueue;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    RecordUpdateEvent updateEvent;
                    TableEventHandler tableEventHandler;
                    if ((tableEventHandler = this.tableEventHandlerByTableId.get((updateEvent = this.updateQueue.take()).getTableId())) == null) {
                        continue;
                    }
                    tableEventHandler.fireEvent(updateEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized <ENTITY> void registerEntity(EntityBuilder<ENTITY> entityBuilder, int userId, Consumer<EntityUpdate<ENTITY>> listener) {
        if (SessionContext.currentOrNull() == null) {
            throw new RuntimeException("Error: cannot register entity update listener without session context!");
        }
        if (userId <= 0) {
            throw new RuntimeException("Error: cannot register entity update listener without userId!");
        }
        Consumer<RecordUpdateEvent> recordUpdateEventConsumer = recordUpdateEvent -> {
            if (userId != recordUpdateEvent.getUserId()) {
                Object entity = entityBuilder.build(recordUpdateEvent.getRecordId());
                EntityUpdate<Object> entityEntityUpdate = new EntityUpdate<Object>(entity, recordUpdateEvent.getUserId(), EntityUpdateType.create(recordUpdateEvent.getType()));
                listener.accept(entityEntityUpdate);
            }
        };
        TableEventHandler tableEventHandler = this.tableEventHandlerByTableId.get(entityBuilder.getTableId());
        if (tableEventHandler == null) {
            tableEventHandler = new TableEventHandler(entityBuilder.getTableId());
            this.tableEventHandlerByTableId.put(entityBuilder.getTableId(), tableEventHandler);
        }
        tableEventHandler.addListener(recordUpdateEventConsumer);
    }

    public static class TableEventHandler {
        private final int tableId;
        private final Event<RecordUpdateEvent> event = new Event();

        public TableEventHandler(int tableId) {
            this.tableId = tableId;
        }

        public void fireEvent(RecordUpdateEvent recordUpdateEvent) {
            this.event.fire((Object)recordUpdateEvent);
        }

        public void addListener(Consumer<RecordUpdateEvent> consumer) {
            this.event.addListener(consumer);
        }

        public int getTableId() {
            return this.tableId;
        }
    }
}

