package org.teamapps.protocol.system;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class SystemLogEntry extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<SystemLogEntry> decoder = new PojoObjectDecoder<SystemLogEntry>() {
		@Override
		public SystemLogEntry decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new SystemLogEntry(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating SystemLogEntry instance", e);
			}
			return null;
		}

		@Override
		public SystemLogEntry decode(Element element, FileDataReader fileDataReader) {
			return new SystemLogEntry(element, fileDataReader);
		}

        @Override
        public SystemLogEntry decode(String xml, FileDataReader fileDataReader) {
            try {
                return new SystemLogEntry(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating SystemLogEntry instance", e);
            }
            return null;
        }

		@Override
		public SystemLogEntry defaultMessage() {
			return (SystemLogEntry) new SystemLogEntry().setDefaultValues(ApplicationServerProtocol.MODEL_COLLECTION);
		}

		@Override
		public SystemLogEntry remap(MessageRecord message) {
			return new SystemLogEntry(message, ApplicationServerProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<SystemLogEntry> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ApplicationServerProtocol.MODEL_COLLECTION;
	}

    public static SystemLogEntry remap(MessageRecord message) {
        return new SystemLogEntry(message, ApplicationServerProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#t.sle";


	public SystemLogEntry() {
		super(ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public SystemLogEntry(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public SystemLogEntry(DataInputStream dis) throws IOException {
		super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(byte[] bytes) throws IOException {
		super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
	}

	public SystemLogEntry(Element element, FileDataReader fileDataReader) {
		super(element, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
	}

    public SystemLogEntry(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ApplicationServerProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ApplicationServerProtocol.MODEL_COLLECTION);
    }

	public int getLogId() {
		return getIntAttribute("logId");
	}

	public SystemLogEntry setLogId(int value) {
		setIntAttribute("logId", value);
		return this;
	}

	public long getNodeId() {
		return getLongAttribute("nodeId");
	}

	public SystemLogEntry setNodeId(long value) {
		setLongAttribute("nodeId", value);
		return this;
	}

	public int getUserId() {
		return getIntAttribute("userId");
	}

	public SystemLogEntry setUserId(int value) {
		setIntAttribute("userId", value);
		return this;
	}

	public long getTimestamp() {
		return getLongAttribute("timestamp");
	}

	public SystemLogEntry setTimestamp(long value) {
		setLongAttribute("timestamp", value);
		return this;
	}

	public int getLogLevel() {
		return getIntAttribute("logLevel");
	}

	public SystemLogEntry setLogLevel(int value) {
		setIntAttribute("logLevel", value);
		return this;
	}

	public int getManagedApplicationId() {
		return getIntAttribute("managedApplicationId");
	}

	public SystemLogEntry setManagedApplicationId(int value) {
		setIntAttribute("managedApplicationId", value);
		return this;
	}

	public int getManagedApplicationPerspectiveId() {
		return getIntAttribute("managedApplicationPerspectiveId");
	}

	public SystemLogEntry setManagedApplicationPerspectiveId(int value) {
		setIntAttribute("managedApplicationPerspectiveId", value);
		return this;
	}

	public String getApplicationVersion() {
		return getStringAttribute("applicationVersion");
	}

	public SystemLogEntry setApplicationVersion(String value) {
		setStringAttribute("applicationVersion", value);
		return this;
	}

	public String getExceptionClass() {
		return getStringAttribute("exceptionClass");
	}

	public SystemLogEntry setExceptionClass(String value) {
		setStringAttribute("exceptionClass", value);
		return this;
	}

	public String getThreadName() {
		return getStringAttribute("threadName");
	}

	public SystemLogEntry setThreadName(String value) {
		setStringAttribute("threadName", value);
		return this;
	}

	public String getMessage() {
		return getStringAttribute("message");
	}

	public SystemLogEntry setMessage(String value) {
		setStringAttribute("message", value);
		return this;
	}

	public String getStackTrace() {
		return getStringAttribute("stackTrace");
	}

	public SystemLogEntry setStackTrace(String value) {
		setStringAttribute("stackTrace", value);
		return this;
	}

	public String getMarker() {
		return getStringAttribute("marker");
	}

	public SystemLogEntry setMarker(String value) {
		setStringAttribute("marker", value);
		return this;
	}



}