/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.controlcenter.database.DbExplorerUtils;
import org.teamapps.application.server.controlcenter.database.TableExplorerView;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfoImpl;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;

public class DatabasePerspective
extends AbstractManagedApplicationPerspective {
    private final UserSessionData userSessionData;
    private final UniversalDB universalDB;
    private final TwoWayBindableValue<TableIndex> selectedTable = TwoWayBindableValue.create();
    private boolean showDeletedRecords = false;
    private View timeLineView;
    private View tableView;
    private View formView;

    public DatabasePerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.universalDB = this.userSessionData.getRegistry().getUniversalDB();
        this.createUi();
    }

    private void createUi() {
        this.timeLineView = this.getPerspective().addView(View.createView((String)"top", (Icon)ApplicationIcons.CHART_LINE, (String)this.getLocalized("org.teamapps.dictionary.timeline"), null));
        this.tableView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.TABLE, (String)this.getLocalized("org.teamapps.dictionary.table"), null));
        this.formView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.FORM, (String)this.getLocalized("org.teamapps.dictionary.form"), null));
        this.formView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        List databases = this.universalDB.getSchemaIndex().getDatabases();
        ArrayList<DatabaseNode> databaseNodes = new ArrayList<DatabaseNode>();
        ArrayList<TableIndex> applicationDbTables = new ArrayList<TableIndex>();
        TableIndex firstIndex = null;
        String fixedDatabaseName = this.isAppFilter() ? this.getMainApplication().getName() : null;
        for (DatabaseIndex database : databases) {
            DatabaseNode dbNode = new DatabaseNode(database);
            if (fixedDatabaseName != null && !fixedDatabaseName.equals(database.getName())) continue;
            databaseNodes.add(dbNode);
            for (TableIndex table : database.getTables()) {
                if (fixedDatabaseName != null) {
                    applicationDbTables.add(table);
                }
                DatabaseNode tableNode = new DatabaseNode(table, dbNode);
                databaseNodes.add(tableNode);
                if (firstIndex != null) continue;
                firstIndex = table;
            }
        }
        ListTreeModel treeModel = new ListTreeModel(databaseNodes);
        Tree tree = new Tree((TreeModel)treeModel);
        treeModel.setTreeNodeInfoFunction(node -> new TreeNodeInfoImpl((Object)node.getParent(), false, true, false));
        tree.setPropertyProvider((databaseNode, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", databaseNode.getIcon());
            map.put("caption", databaseNode.getTitle());
            map.put("badge", databaseNode.getBadge());
            return map;
        });
        tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        tree.setOpenOnSelection(true);
        tree.setShowExpanders(false);
        tree.setEnforceSingleExpandedPath(true);
        tree.setTemplateDecider(databaseNode -> databaseNode.getTableIndex() != null ? BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE : BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE);
        this.setPerspectiveMenuPanel((Component)tree, null);
        tree.onNodeSelected.addListener(node -> {
            TableIndex tableIndex = node.getTableIndex();
            if (tableIndex != null) {
                this.selectedTable.set((Object)tableIndex);
            }
        });
        this.selectedTable.onChanged().addListener(this::showTable);
        this.selectedTable.set((Object)firstIndex);
        this.createToolbarButtons(this.getPerspective(), applicationDbTables);
    }

    public void showTable(TableIndex tableIndex) {
        new TableExplorerView(this.getApplicationInstanceData(), tableIndex, this.timeLineView, this.tableView, this.formView, this.showDeletedRecords);
    }

    public void showTimeGraph(boolean visible) {
        this.timeLineView.setVisible(visible);
    }

    private void createToolbarButtons(Perspective perspective, List<TableIndex> applicationDbTables) {
        ToolbarButtonGroup buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        if (!applicationDbTables.isEmpty()) {
            ToolbarButton tablesSelectionButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.DATA_TABLE, (String)this.getLocalized("org.teamapps.dictionary.table"), (String)this.getLocalized(this.getMainApplication().getTitleKey())));
            SimpleItemView itemView = new SimpleItemView();
            SimpleItemGroup itemGroup = itemView.addSingleColumnGroup(ApplicationIcons.DATA_TABLE, this.getLocalized("org.teamapps.dictionary.table"));
            for (TableIndex tableIndex : applicationDbTables) {
                itemGroup.addItem((Icon)ApplicationIcons.TABLE, (String)DbExplorerUtils.createTitleFromCamelCase((String)tableIndex.getName()), (String)DbExplorerUtils.createTitleFromCamelCase((String)tableIndex.getDatabaseIndex().getName())).onClick.addListener(() -> this.selectedTable.set((Object)tableIndex));
            }
            tablesSelectionButton.setDropDownComponent((Component)itemView);
        }
        buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton showTimeGraphButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.CHART_LINE, (String)this.getLocalized("org.teamapps.dictionary.timeline"), (String)this.getLocalized("org.teamapps.dictionary.timeline")));
        ToolbarButton hideTimeGraphButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.CHART_LINE, (Icon)ApplicationIcons.ERROR), (String)this.getLocalized("org.teamapps.dictionary.timeline"), (String)this.getLocalized("org.teamapps.dictionary.timeline")));
        hideTimeGraphButton.setVisible(false);
        if (this.isAllowed(Privileges.DATABASE_PERSPECTIVE, Privilege.SHOW_RECYCLE_BIN)) {
            buttonGroup = perspective.addWorkspaceButtonGroup(new ToolbarButtonGroup());
            ToolbarButton showDeletedButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.GARBAGE_EMPTY, (String)this.getLocalized("org.teamapps.dictionary.recycleBin"), (String)this.getLocalized("org.teamapps.dictionary.showRecycleBin")));
            ToolbarButton hideDeletedButton = buttonGroup.addButton(ToolbarButton.create((Icon)CompositeIcon.of((Icon)ApplicationIcons.GARBAGE_EMPTY, (Icon)ApplicationIcons.ERROR), (String)this.getLocalized("org.teamapps.dictionary.recycleBin"), (String)this.getLocalized("org.teamapps.dictionary.recycleBin")));
            hideDeletedButton.setVisible(false);
            showDeletedButton.onClick.addListener(() -> {
                showDeletedButton.setVisible(false);
                hideDeletedButton.setVisible(true);
                this.showDeletedRecords = true;
                this.showTable((TableIndex)this.selectedTable.get());
                this.tableView.focus();
            });
            hideDeletedButton.onClick.addListener(() -> {
                showDeletedButton.setVisible(true);
                hideDeletedButton.setVisible(false);
                this.showDeletedRecords = false;
                this.showTable((TableIndex)this.selectedTable.get());
                this.tableView.focus();
            });
        }
        showTimeGraphButton.onClick.addListener(() -> {
            showTimeGraphButton.setVisible(false);
            hideTimeGraphButton.setVisible(true);
            this.showTimeGraph(true);
            this.timeLineView.focus();
        });
        hideTimeGraphButton.onClick.addListener(() -> {
            hideTimeGraphButton.setVisible(false);
            showTimeGraphButton.setVisible(true);
            this.showTimeGraph(false);
            this.tableView.focus();
        });
    }

    public static class DatabaseNode {
        private final DatabaseIndex databaseIndex;
        private final TableIndex tableIndex;
        private DatabaseNode parent;

        public DatabaseNode(DatabaseIndex databaseIndex) {
            this.databaseIndex = databaseIndex;
            this.tableIndex = null;
        }

        public DatabaseNode(TableIndex tableIndex, DatabaseNode parent) {
            this.tableIndex = tableIndex;
            this.databaseIndex = null;
            this.parent = parent;
        }

        public Icon getIcon() {
            return this.tableIndex != null ? ApplicationIcons.TABLE : ApplicationIcons.DATA_TABLE;
        }

        public String getTitle() {
            String value = this.tableIndex != null ? this.tableIndex.getName() : this.databaseIndex.getName();
            return DbExplorerUtils.createTitleFromCamelCase(value);
        }

        public String getBadge() {
            if (this.tableIndex != null) {
                return this.tableIndex.getDeletedRecordsCount() > 0 ? this.tableIndex.getCount() + " \u2326" + this.tableIndex.getDeletedRecordsCount() : "" + this.tableIndex.getCount();
            }
            return null;
        }

        public DatabaseIndex getDatabaseIndex() {
            return this.databaseIndex;
        }

        public TableIndex getTableIndex() {
            return this.tableIndex;
        }

        public DatabaseNode getParent() {
            return this.parent;
        }
    }
}

