/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.database;

import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.database.DbExplorerUtils;
import org.teamapps.application.server.controlcenter.database.TableExplorerModel;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormPanel;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.datetime.LocalDateField;
import org.teamapps.ux.component.field.datetime.LocalTimeField;
import org.teamapps.ux.component.field.richtext.RichTextEditor;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.table.ListTableModel;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.table.TableModel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.timegraph.graph.AbstractGraph;
import org.teamapps.ux.component.timegraph.graph.LineGraph;
import org.teamapps.ux.component.timegraph.model.LineGraphModel;
import org.teamapps.ux.component.timegraph.model.timestamps.PartitioningTimestampsLineGraphModel;
import org.teamapps.ux.component.timegraph.model.timestamps.StaticTimestampsModel;
import org.teamapps.ux.component.timegraph.model.timestamps.TimestampsModel;

public class TableExplorerView
extends AbstractApplicationView {
    private final TableIndex tableIndex;
    private final View timeLineView;
    private final View tableView;
    private final View formView;
    private final boolean deletedRecords;

    public TableExplorerView(ApplicationInstanceData applicationInstanceData, TableIndex tableIndex, View timeLineView, View tableView, View formView, boolean deletedRecords) {
        super(applicationInstanceData);
        this.tableIndex = tableIndex;
        this.timeLineView = timeLineView;
        this.tableView = tableView;
        this.formView = formView;
        this.deletedRecords = deletedRecords;
        this.createUi();
    }

    private void createUi() {
        TableExplorerModel model = new TableExplorerModel(this.tableIndex, this.deletedRecords, this.getApplicationInstanceData());
        Map<String, Function<Integer, Object>> fieldValueFunctionMap = this.createFieldValueFunctionMap(this.tableIndex);
        Table table = new Table();
        table.setModel((TableModel)model);
        table.setDisplayAsList(true);
        table.setPropertyProvider(this.createTablePropertyProvider(fieldValueFunctionMap, this.tableIndex));
        this.addColumn("ID", (AbstractField<?>)new NumberField(0), 70, (Table<Integer>)table);
        this.createTableFields(this.tableIndex, (Table<Integer>)table);
        ResponsiveForm form = new ResponsiveForm(120, 200, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        this.addFormColumn("ID", (AbstractField<?>)new NumberField(0), formLayout);
        this.createFormFields(this.tableIndex, formLayout, (Event<Integer>)table.onRowSelected);
        table.onRowSelected.addListener(id -> {
            form.setFieldValue("ID", id);
            this.tableIndex.getColumnIndices().stream().filter(c -> c.getColumnType() != ColumnType.MULTI_REFERENCE).forEach(c -> {
                Function valueFunction = (Function)fieldValueFunctionMap.get(c.getName());
                if (valueFunction != null) {
                    form.setFieldValue(c.getName(), valueFunction.apply(id));
                }
            });
        });
        ColumnIndex defaultTimeLineColumn = model.getDefaultTimeLineColumn();
        if (defaultTimeLineColumn != null) {
            TwoWayBindableValue timeLineColumn = TwoWayBindableValue.create();
            List<ColumnIndex> timeLineColumns = model.getTimeLineColumns();
            ComboBox timeLineComboBox = ComboBoxUtils.createRecordComboBox(timeLineColumns, (columnIndex, collection) -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("icon", ApplicationIcons.CALENDAR_CLOCK);
                map.put("caption", DbExplorerUtils.createTitleFromCamelCase(columnIndex.getName()));
                return map;
            }, (Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
            timeLineComboBox.setValue((Object)defaultTimeLineColumn);
            timeLineComboBox.onValueChanged.addListener(arg_0 -> ((TwoWayBindableValue)timeLineColumn).set(arg_0));
            RgbaColor color = Color.MATERIAL_BLUE_700;
            TimeGraph timeGraph = new TimeGraph();
            StaticTimestampsModel timestampsModel = new StaticTimestampsModel(){

                public Interval getDomainX() {
                    Interval domainX = super.getDomainX();
                    long diff = (domainX.getMax() - domainX.getMin()) / 20L;
                    return new Interval(domainX.getMin() - diff, domainX.getMax() + diff);
                }
            };
            timeLineColumn.onChanged().addListener(col -> {
                Function<Integer, Long> timeLineDataFunction = model.createTimeLineDataFunction((ColumnIndex)col);
                BitSet recordBitSet = this.deletedRecords ? this.tableIndex.getDeletedRecords() : this.tableIndex.getRecords();
                long[] data = new long[recordBitSet.cardinality()];
                int pos = 0;
                int id = recordBitSet.nextSetBit(0);
                while (id >= 0) {
                    data[pos] = timeLineDataFunction.apply(id);
                    ++pos;
                    id = recordBitSet.nextSetBit(id + 1);
                }
                timestampsModel.setEventTimestamps(data);
            });
            timeLineColumn.set((Object)defaultTimeLineColumn);
            PartitioningTimestampsLineGraphModel lineGraphModel = new PartitioningTimestampsLineGraphModel((TimestampsModel)timestampsModel);
            LineGraph lineGraph = new LineGraph((LineGraphModel)lineGraphModel, LineChartCurveType.MONOTONE, 0.5f, (Color)color, (Color)color.withAlpha(0.05f));
            lineGraph.setAreaColorScaleMin((Color)color.withAlpha(0.05f));
            lineGraph.setAreaColorScaleMax((Color)color.withAlpha(0.5f));
            lineGraph.setYScaleType(ScaleType.SYMLOG);
            lineGraph.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
            lineGraph.setYZeroLineVisible(false);
            timeGraph.addGraph((AbstractGraph)lineGraph);
            timeGraph.onIntervalSelected.addListener(interval -> model.setTimeLineFilter(((ColumnIndex)timeLineComboBox.getValue()).getName(), (Interval)interval));
            this.timeLineView.getPanel().setRightHeaderField((AbstractField)timeLineComboBox);
            this.timeLineView.setComponent((Component)timeGraph);
        } else {
            this.timeLineView.setComponent(null);
        }
        this.tableView.setComponent((Component)table);
        this.tableView.setTitle(this.tableIndex.getName() + " (" + model.getCount() + ")");
        model.onAllDataChanged().addListener(() -> this.tableView.setTitle(this.tableIndex.getName() + " (" + model.getCount() + ")"));
        TextField queryField = new TextField();
        queryField.setEmptyText(this.getLocalized("org.teamapps.dictionary.search___", new Object[0]));
        queryField.onTextInput.addListener(model::setQuery);
        this.tableView.getPanel().setRightHeaderField((AbstractField)queryField);
        this.formView.setComponent((Component)form);
        table.onRowSelected.addListener(id -> this.formView.setTitle("ID: " + id));
    }

    private Map<String, Function<Integer, Object>> createFieldValueFunctionMap(TableIndex tableIndex) {
        HashMap<String, Function<Integer, Object>> fieldValueFunctionMap = new HashMap<String, Function<Integer, Object>>();
        for (ColumnIndex columnIndex : tableIndex.getColumnIndices()) {
            Function<Integer, Object> valueFunction = arg_0 -> ((ColumnIndex)columnIndex).getGenericValue(arg_0);
            String fieldName = columnIndex.getName();
            switch (columnIndex.getColumnType()) {
                case TRANSLATABLE_TEXT: {
                    TranslatableTextIndex translatableTextIndex = (TranslatableTextIndex)columnIndex;
                    valueFunction = id -> {
                        TranslatableText value = translatableTextIndex.getValue(id.intValue());
                        return value != null ? value.getText() : null;
                    };
                    break;
                }
                case FILE: {
                    FileIndex fileIndex = (FileIndex)columnIndex;
                    valueFunction = id -> {
                        FileValue fileValue = fileIndex.getValue(id.intValue());
                        if (fileValue != null) {
                            String fileName = fileValue.getFileName();
                            String size = FileUtils.byteCountToDisplaySize((long)fileValue.getSize());
                            File file = fileValue.retrieveFile();
                            return fileName + " (" + size + "), " + file.length() + ", " + file.getPath();
                        }
                        return null;
                    };
                    break;
                }
                case SINGLE_REFERENCE: {
                    SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)columnIndex;
                    List textIndices = singleReferenceIndex.getReferencedTable().getColumnIndices().stream().filter(c -> c.getColumnType() == ColumnType.TEXT).limit(3L).collect(Collectors.toList());
                    valueFunction = id -> {
                        int refId = singleReferenceIndex.getValue(id.intValue());
                        return refId == 0 ? null : "\u279e" + refId + ": " + textIndices.stream().map(idx -> idx.getStringValue(refId)).filter(Objects::nonNull).collect(Collectors.joining(" "));
                    };
                    break;
                }
                case MULTI_REFERENCE: {
                    MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)columnIndex;
                    valueFunction = id -> {
                        int count = multiReferenceIndex.getReferencesCount(id.intValue());
                        if (count == 0) {
                            return null;
                        }
                        List references = multiReferenceIndex.getReferencesAsList(id.intValue());
                        return count + " (" + references.stream().limit(25L).map(v -> "" + v).collect(Collectors.joining(", ")) + ")";
                    };
                    break;
                }
                case TIMESTAMP: {
                    valueFunction = id -> {
                        IntegerIndex integerIndex = (IntegerIndex)columnIndex;
                        int value = integerIndex.getValue(id.intValue());
                        return value == 0 ? null : Instant.ofEpochSecond(value);
                    };
                    break;
                }
                case DATE: {
                    valueFunction = id -> {
                        LongIndex integerIndex = (LongIndex)columnIndex;
                        long value = integerIndex.getValue(id.intValue());
                        return value == 0L ? null : Instant.ofEpochMilli(value).atOffset(ZoneOffset.UTC).toLocalDate();
                    };
                    break;
                }
                case TIME: {
                    valueFunction = id -> {
                        IntegerIndex integerIndex = (IntegerIndex)columnIndex;
                        int value = integerIndex.getValue(id.intValue());
                        return value == 0 ? null : Instant.ofEpochSecond(value).atOffset(ZoneOffset.UTC).toLocalTime();
                    };
                    break;
                }
                case DATE_TIME: {
                    valueFunction = id -> {
                        LongIndex longIndex = (LongIndex)columnIndex;
                        long value = longIndex.getValue(id.intValue());
                        return value == 0L ? null : Instant.ofEpochMilli(value);
                    };
                    break;
                }
                case LOCAL_DATE: {
                    valueFunction = id -> {
                        LongIndex longIndex = (LongIndex)columnIndex;
                        long value = longIndex.getValue(id.intValue());
                        return value == 0L ? null : Instant.ofEpochMilli(value).atOffset(ZoneOffset.UTC).toLocalDate();
                    };
                    break;
                }
                case ENUM: {
                    List enumValues = columnIndex.getTable().getTable().getColumn(columnIndex.getName()).getEnumValues();
                    ShortIndex enumIndex = (ShortIndex)columnIndex;
                    valueFunction = id -> {
                        short value = enumIndex.getValue(id.intValue());
                        return value == 0 ? null : enumValues.get(value - 1);
                    };
                    break;
                }
                case BINARY: {
                    valueFunction = arg_0 -> ((ColumnIndex)columnIndex).getStringValue(arg_0);
                }
            }
            fieldValueFunctionMap.put(fieldName, valueFunction);
        }
        return fieldValueFunctionMap;
    }

    private void createFormFields(TableIndex tableIndex, ResponsiveFormLayout formLayout, Event<Integer> onTableRowSelected) {
        for (ColumnIndex columnIndex : this.getSortedColumns(tableIndex)) {
            String fieldName = columnIndex.getName();
            switch (columnIndex.getColumnType()) {
                case BOOLEAN: 
                case BITSET_BOOLEAN: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new CheckBox(), formLayout);
                    break;
                }
                case SHORT: 
                case INT: 
                case LONG: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new NumberField(0), formLayout);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new NumberField(2), formLayout);
                    break;
                }
                case TEXT: {
                    this.addFormColumn(fieldName, this.getFormTextField((TextIndex)columnIndex), formLayout);
                    break;
                }
                case TRANSLATABLE_TEXT: 
                case FILE: 
                case SINGLE_REFERENCE: 
                case ENUM: 
                case BINARY: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new TextField(), formLayout);
                    break;
                }
                case MULTI_REFERENCE: {
                    MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)columnIndex;
                    TableIndex referencedTable = multiReferenceIndex.getReferencedTable();
                    Map<String, Function<Integer, Object>> subTableValueFunctionMap = this.createFieldValueFunctionMap(referencedTable);
                    Table subTable = new Table();
                    ListTableModel listTableModel = new ListTableModel();
                    subTable.setModel((TableModel)listTableModel);
                    subTable.setPropertyProvider(this.createTablePropertyProvider(subTableValueFunctionMap, referencedTable));
                    subTable.setDisplayAsList(true);
                    this.createTableFields(referencedTable, (Table<Integer>)subTable);
                    FormPanel formPanel = new FormPanel(this.getApplicationInstanceData());
                    formPanel.setTopSpace(100);
                    formPanel.setTable(subTable, true, false, false);
                    Panel panel = formPanel.getPanel();
                    panel.setHideTitleBar(false);
                    panel.setIcon(ApplicationIcons.TABLE);
                    String title = this.getTitle(fieldName);
                    panel.setTitle(title);
                    this.addFormColumn(fieldName, (Component)panel, formLayout);
                    onTableRowSelected.addListener(selectedId -> {
                        List referencesAsList = multiReferenceIndex.getReferencesAsList(selectedId.intValue());
                        listTableModel.setList(referencesAsList);
                        panel.setTitle(title + " (" + referencesAsList.size() + ")");
                    });
                    break;
                }
                case TIMESTAMP: 
                case DATE_TIME: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new InstantDateTimeField(), formLayout);
                    break;
                }
                case DATE: 
                case LOCAL_DATE: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new LocalDateField(), formLayout);
                    break;
                }
                case TIME: {
                    this.addFormColumn(fieldName, (AbstractField<?>)new LocalTimeField(), formLayout);
                }
            }
        }
    }

    private void createTableFields(TableIndex tableIndex, Table<Integer> table) {
        for (ColumnIndex columnIndex : this.getSortedColumns(tableIndex)) {
            String fieldName = columnIndex.getName();
            switch (columnIndex.getColumnType()) {
                case BOOLEAN: 
                case BITSET_BOOLEAN: {
                    this.addColumn(fieldName, (AbstractField<?>)new CheckBox(), 70, table);
                    break;
                }
                case SHORT: 
                case INT: 
                case LONG: {
                    this.addColumn(fieldName, (AbstractField<?>)new NumberField(0), 70, table);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    this.addColumn(fieldName, (AbstractField<?>)new NumberField(2), 100, table);
                    break;
                }
                case TEXT: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 200, table);
                    break;
                }
                case TRANSLATABLE_TEXT: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 210, table);
                    break;
                }
                case FILE: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 180, table);
                    break;
                }
                case SINGLE_REFERENCE: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 250, table);
                    break;
                }
                case MULTI_REFERENCE: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 175, table);
                    break;
                }
                case TIMESTAMP: {
                    this.addColumn(fieldName, (AbstractField<?>)new InstantDateTimeField(), 200, table);
                    break;
                }
                case DATE: {
                    this.addColumn(fieldName, (AbstractField<?>)new LocalDateField(), 200, table);
                    break;
                }
                case TIME: {
                    this.addColumn(fieldName, (AbstractField<?>)new LocalTimeField(), 200, table);
                    break;
                }
                case DATE_TIME: {
                    this.addColumn(fieldName, (AbstractField<?>)new InstantDateTimeField(), 170, table);
                    break;
                }
                case LOCAL_DATE: {
                    this.addColumn(fieldName, (AbstractField<?>)new LocalDateField(), 150, table);
                    break;
                }
                case ENUM: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 150, table);
                    break;
                }
                case BINARY: {
                    this.addColumn(fieldName, (AbstractField<?>)new TextField(), 120, table);
                }
            }
        }
    }

    private List<ColumnIndex> getSortedColumns(TableIndex tableIndex) {
        return tableIndex.getColumnIndices().stream().sorted((o1, o2) -> {
            if (this.isMetaField((ColumnIndex<?, ?>)o1) && !this.isMetaField((ColumnIndex<?, ?>)o2)) {
                return 1;
            }
            if (!this.isMetaField((ColumnIndex<?, ?>)o1) && this.isMetaField((ColumnIndex<?, ?>)o2)) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    private AbstractField<String> getFormTextField(TextIndex textIndex) {
        RichTextEditor field;
        BitSet bitSet = this.tableIndex.getRecords();
        int checkedRecords = 0;
        int maxLength = 0;
        boolean containsHtml = false;
        boolean containsNewLines = false;
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            String value = textIndex.getValue(id);
            if (value != null) {
                if (value.toLowerCase().contains("</p>") || value.toLowerCase().contains("</td>")) {
                    containsHtml = true;
                }
                if (value.contains("\n")) {
                    containsNewLines = true;
                    break;
                }
                maxLength = Math.max(maxLength, value.length());
            }
            if (++checkedRecords > 1000) break;
            id = bitSet.nextSetBit(id + 1);
        }
        if (containsHtml) {
            field = new RichTextEditor();
            field.setCssStyle("height", Length.ofPixels((int)350).toCssString());
        } else if (containsNewLines || maxLength > 255) {
            field = new MultiLineTextField();
            field.setCssStyle("height", Length.ofPixels((int)250).toCssString());
        } else {
            field = new TextField();
        }
        return field;
    }

    private boolean isMetaField(ColumnIndex<?, ?> columnIndex) {
        return org.teamapps.universaldb.schema.Table.isReservedMetaName((String)columnIndex.getName());
    }

    private void addFormColumn(String fieldName, AbstractField<?> field, ResponsiveFormLayout formLayout) {
        String label = this.getTitle(fieldName);
        formLayout.addLabelAndField(null, label, fieldName, field);
    }

    private void addFormColumn(String fieldName, Component component, ResponsiveFormLayout formLayout) {
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false).setMargin(Spacing.px((int)0, (int)5));
        formLayout.addLabelAndComponent(component);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false).setMargin(Spacing.px((int)0, (int)5));
    }

    private String getTitle(String fieldName) {
        return DbExplorerUtils.createTitleFromCamelCase(fieldName);
    }

    private void addColumn(String name, AbstractField<?> field, int width, Table<Integer> table) {
        TableColumn column = new TableColumn(name, this.getTitle(name), field);
        column.setDefaultWidth(width);
        table.addColumn(column);
    }

    private PropertyProvider<Integer> createTablePropertyProvider(Map<String, Function<Integer, Object>> fieldValueFunctionMap, TableIndex tableIndex) {
        return (id, collection) -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("ID", (Integer)id);
            for (ColumnIndex columnIndex : tableIndex.getColumnIndices()) {
                Function valueFunction = (Function)fieldValueFunctionMap.get(columnIndex.getName());
                map.put(columnIndex.getName(), (Integer)valueFunction.apply(id));
            }
            return map;
        };
    }
}

