/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.AbstractPerspectiveBuilder;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.application.perspective.PerspectiveMenuPanel;
import org.teamapps.application.api.localization.Country;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.controlcenter.organization.OrganizationChartPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationFieldPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationUnitTypePerspectiveBuilder;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ui.address.AddressForm;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.IconUtils;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.application.ux.localize.TranslatableTextUtils;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.GeoLocationType;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.Tree;

public class OrganizationPerspective
extends AbstractManagedApplicationPerspective {
    public OrganizationPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        OrganizationPerspectiveBuilder organizationPerspectiveBuilder = new OrganizationPerspectiveBuilder();
        PerspectiveMenuPanel menuPanel = PerspectiveMenuPanel.createMenuPanel((ApplicationInstanceData)this.getApplicationInstanceData(), (AbstractPerspectiveBuilder[])new AbstractPerspectiveBuilder[]{new OrganizationChartPerspectiveBuilder(), organizationPerspectiveBuilder, new OrganizationUnitTypePerspectiveBuilder(), new OrganizationFieldPerspectiveBuilder()});
        menuPanel.addInstantiatedPerspective((AbstractPerspectiveBuilder)organizationPerspectiveBuilder, (ApplicationPerspective)this);
        this.setPerspectiveMenuPanel(menuPanel.getComponent(), (Component)menuPanel.getButtonMenu());
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.ELEMENTS_HIERARCHY, this.getLocalized("organization.organizationUnits"), this.getApplicationInstanceData(), OrganizationUnit::filter, Privileges.ORGANIZATION_UNIT_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        Tree tree = entityModelBuilder.createTree((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()), OrganizationUnit::getParent, unit -> OrganizationUtils.getLevel(unit) < 2);
        entityModelBuilder.updateModels();
        TemplateField parentUnitField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        TranslatableField translatableNameField = TranslatableTextUtils.createTranslatableField((ApplicationInstanceData)this.getApplicationInstanceData());
        ComboBox<OrganizationUnitType> unitTypeComboBox = this.createOrgUnitTypeComboBox((EntityModelBuilder<OrganizationUnit>)entityModelBuilder);
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox();
        AddressForm addressForm = new AddressForm(this.getApplicationInstanceData());
        addressForm.setWithName(true);
        addressForm.setWithGeoCoordinates(true);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection(ApplicationIcons.FOLDER, this.getLocalized(""));
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.parentUnit"), (AbstractField)parentUnitField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.unitName"), (AbstractField)translatableNameField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.unitType"), unitTypeComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("organizationUnit.icon"), (AbstractField)iconComboBox);
        addressForm.createAddressSection(formLayout);
        addressForm.addFields(formLayout);
        formController.addNotNull((AbstractField)translatableNameField);
        formController.addNotNull(unitTypeComboBox);
        masterDetailController.createViews(this.getPerspective(), (Component)tree, formLayout);
        formController.setCreateNewEntitySupplier(() -> OrganizationUnit.create().setParent((OrganizationUnit)entityModelBuilder.getSelectedRecord()));
        formController.setSaveEntityHandler(unit -> {
            OrganizationUnit parentUnit = unit.getParent();
            if (addressForm.validateAddress() && (parentUnit != null || OrganizationUnit.getCount() == 0)) {
                unit.setParent(parentUnit).setName(translatableNameField.getValue()).setType((OrganizationUnitType)unitTypeComboBox.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)((Icon)iconComboBox.getValue()))).setAddress(addressForm.getAddress());
                return true;
            }
            return false;
        });
        entityModelBuilder.getOnSelectionEvent().addListener(unit -> {
            parentUnitField.setValue((Object)unit.getParent());
            translatableNameField.setValue(unit.getName());
            unitTypeComboBox.setValue((Object)unit.getType());
            iconComboBox.setValue((Object)IconUtils.decodeIcon((String)unit.getIcon()));
            addressForm.setAddress(unit.getAddress());
            if (!unit.isStored()) {
                OrganizationUnit countryParent;
                if (unit.getParent() != null) {
                    unitTypeComboBox.setValue((Object)unit.getParent().getType().getDefaultChildType());
                }
                if (OrganizationUtils.getParentWithGeoType(unit, GeoLocationType.COUNTRY) != null && (countryParent = OrganizationUtils.getParentWithGeoType(unit, GeoLocationType.COUNTRY)).getAddress() != null) {
                    addressForm.getCountryComboBox().setValue((Object)Country.getCountryByIsoCode((String)countryParent.getAddress().getCountry()));
                }
            }
        });
        if (OrganizationUnit.getCount() == 0) {
            entityModelBuilder.setSelectedRecord((Object)OrganizationUnit.create().setParent(null));
        }
    }

    private ComboBox<OrganizationUnitType> createOrgUnitTypeComboBox(EntityModelBuilder<OrganizationUnit> entityModelBuilder) {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        PropertyProvider<OrganizationUnitType> propertyProvider = PropertyProviders.creatOrganizationUnitTypePropertyProvider(this.getApplicationInstanceData());
        comboBox.setModel(query -> {
            List<OrganizationUnitType> allowedTypes;
            OrganizationUnit selectedRecord = (OrganizationUnit)entityModelBuilder.getSelectedRecord();
            List<OrganizationUnitType> list = allowedTypes = selectedRecord != null && selectedRecord.getParent() != null ? selectedRecord.getParent().getType().getPossibleChildrenTypes() : OrganizationUnitType.getAll();
            if (query == null || query.isBlank()) {
                return allowedTypes;
            }
            String q = query.toLowerCase();
            return allowedTypes.stream().filter(type -> ((String)propertyProvider.getValues(type, Collections.emptyList()).get("caption")).toLowerCase().contains(q)).collect(Collectors.toList());
        });
        comboBox.setPropertyProvider(propertyProvider);
        comboBox.setRecordToStringFunction(unitType -> (String)propertyProvider.getValues(unitType, Collections.emptyList()).get("caption"));
        return comboBox;
    }
}

