/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.systemlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.application.ux.form.FormController;
import org.teamapps.application.ux.view.MasterDetailController;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.model.controlcenter.LogLevel;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.SystemLog;
import org.teamapps.model.controlcenter.User;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class SystemLogPerspective
extends AbstractManagedApplicationPerspective {
    private final UserSessionData userSessionData;

    public SystemLogPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        Supplier<Query> querySupplier = () -> this.isAppFilter() ? SystemLog.filter().application(NumericFilter.equalsFilter((Number)this.getMainApplication().getId())) : SystemLog.filter();
        MasterDetailController masterDetailController = new MasterDetailController(ApplicationIcons.CONSOLE, this.getLocalized("systemLog.systemLogs"), this.getApplicationInstanceData(), querySupplier, Privileges.SYSTEM_LOG_PERSPECTIVE);
        EntityModelBuilder entityModelBuilder = masterDetailController.getEntityModelBuilder();
        FormController formController = masterDetailController.getFormController();
        ResponsiveForm form = masterDetailController.getResponsiveForm();
        ComboBox<LogLevel> logLeveComboBox = this.createLogLeveComboBox();
        ComboBox<User> userComboBox = this.createUserComboBox();
        ComboBox<String> exceptionClassComboBox = this.createExceptionClassComboBox();
        ComboBox applicationComboBox = ComboBoxUtils.createRecordComboBox(() -> this.isAppFilter() ? Collections.singletonList(this.getManagedApplication()) : ManagedApplication.getAll(), PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        ComboBox perspectiveComboBox = ComboBoxUtils.createRecordComboBox(() -> applicationComboBox.getValue() == null ? Collections.emptyList() : ((ManagedApplication)applicationComboBox.getValue()).getPerspectives(), PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        ComboBox applicationVersionComboBox = ComboBoxUtils.createRecordComboBox(() -> applicationComboBox.getValue() == null ? Collections.emptyList() : ((ManagedApplication)applicationComboBox.getValue()).getMainApplication().getVersions(), PropertyProviders.createApplicationVersionPropertyProvider(this.userSessionData), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        if (this.isAppFilter()) {
            applicationComboBox.setValue((Object)this.getManagedApplication());
            applicationComboBox.setVisible(false);
        }
        logLeveComboBox.setShowClearButton(true);
        userComboBox.setShowClearButton(true);
        exceptionClassComboBox.setShowClearButton(true);
        applicationComboBox.setShowClearButton(true);
        perspectiveComboBox.setShowClearButton(true);
        applicationVersionComboBox.setShowClearButton(true);
        ResponsiveForm selectionForm = new ResponsiveForm(50, 75, 200);
        selectionForm.setMargin(Spacing.px((int)0));
        ResponsiveFormLayout formLayout = selectionForm.addResponsiveFormLayout(500);
        formLayout.addSection().setCollapsible(false).setPadding(new Spacing(0, 5)).setMargin(new Spacing(4, 2, 4, 2));
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.logLevel"), logLeveComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.application"), (AbstractField)applicationComboBox, false);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.user"), userComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.perspective"), (AbstractField)perspectiveComboBox, false);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.exceptionClass"), exceptionClassComboBox);
        formLayout.addLabelAndField(null, this.getLocalized("applications.installedVersion"), (AbstractField)applicationVersionComboBox, false);
        entityModelBuilder.updateModels();
        Table table = entityModelBuilder.createTable();
        table.setDisplayAsList(true);
        table.setStripedRows(false);
        table.setRowHeight(28);
        table.setCssStyle("background-color", "white");
        table.setCssStyle("border-top", "1px solid " + Color.MATERIAL_GREY_400.toHtmlColorString());
        InstantDateTimeField timeField = new InstantDateTimeField();
        TemplateField logLevelField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createLogLevelPropertyProvider());
        TemplateField messageField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createSystemLogPropertyProvider());
        TemplateField managedApplicationField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TemplateField perspectiveField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TemplateField userField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        table.addColumn(new TableColumn("metaCreationDate", this.getLocalized("org.teamapps.dictionary.date"), (AbstractField)timeField));
        table.addColumn(new TableColumn("logLevel", this.getLocalized("systemLog.logLevel"), (AbstractField)logLevelField).setDefaultWidth(75));
        table.addColumn(new TableColumn("message", this.getLocalized("systemLog.logMessage"), (AbstractField)messageField).setDefaultWidth(230));
        table.addColumn(new TableColumn("managedApplication", this.getLocalized("applicationProvisioning.provisionedApplication"), (AbstractField)managedApplicationField));
        table.addColumn(new TableColumn("managedPerspective", this.getLocalized("systemLog.provisionedPerspective"), (AbstractField)perspectiveField));
        table.addColumn(new TableColumn("metaCreatedBy", this.getLocalized("systemLog.user"), (AbstractField)userField));
        table.addColumn(new TableColumn("applicationVersion", this.getLocalized("applications.installedVersion"), (AbstractField)new TextField()));
        table.setPropertyExtractor((systemLog, propertyName) -> switch (propertyName) {
            case "metaCreationDate" -> systemLog.getMetaCreationDate();
            case "metaCreatedBy" -> {
                if (systemLog.getMetaCreatedBy() > 0) {
                    yield User.getById(systemLog.getMetaCreatedBy());
                }
                yield null;
            }
            case "logLevel" -> systemLog.getLogLevel();
            case "message" -> systemLog;
            case "managedApplication" -> systemLog.getManagedApplication();
            case "managedPerspective" -> systemLog.getManagedPerspective();
            case "application" -> systemLog.getApplication();
            case "applicationVersion" -> {
                if (systemLog.getApplicationVersion() != null) {
                    yield systemLog.getApplicationVersion().getVersion();
                }
                yield null;
            }
            default -> null;
        });
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent((Component)selectionForm);
        verticalLayout.addComponentFillRemaining((Component)table);
        VerticalLayout detailsVerticalLayout = new VerticalLayout();
        detailsVerticalLayout.addComponent((Component)form);
        formLayout = form.addResponsiveFormLayout(450);
        TemplateField applicationFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createApplicationPropertyProvider(this.userSessionData));
        TemplateField managedApplicationFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPropertyProvider(this.userSessionData));
        TemplateField perspectiveFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createManagedApplicationPerspectivePropertyProvider(this.userSessionData));
        TemplateField logLevelFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, this.createLogLevelPropertyProvider());
        TemplateField userFormField = UiUtils.createTemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        DisplayField exceptionClassFormField = new DisplayField();
        DisplayField messageFormField = new DisplayField();
        MultiLineTextField detailsFormField = new MultiLineTextField();
        InstantDateTimeField timeFormField = new InstantDateTimeField();
        timeFormField.setEditingMode(FieldEditingMode.READONLY);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("applicationProvisioning.provisionedApplication"), (AbstractField)managedApplicationFormField);
        formLayout.addLabelAndField(null, this.getLocalized("applications.application"), (AbstractField)applicationFormField);
        formLayout.addLabelAndField(null, this.getLocalized("applications.perspective"), (AbstractField)perspectiveFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.logLevel"), (AbstractField)logLevelFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.exceptionClass"), (AbstractField)exceptionClassFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.user"), (AbstractField)userFormField);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.date"), (AbstractField)timeFormField);
        formLayout.addLabelAndField(null, this.getLocalized("systemLog.logMessage"), (AbstractField)messageFormField);
        detailsVerticalLayout.addComponentFillRemaining((Component)detailsFormField);
        masterDetailController.createViews(this.getPerspective(), (Component)verticalLayout, formLayout, false);
        masterDetailController.setDetailComponent((Component)detailsVerticalLayout);
        Runnable onFilterChange = () -> {
            Predicate<SystemLog> filter = this.createFilter((LogLevel)((Object)((Object)logLeveComboBox.getValue())), (User)userComboBox.getValue(), (String)exceptionClassComboBox.getValue(), (ManagedApplication)applicationComboBox.getValue(), (ManagedApplicationPerspective)perspectiveComboBox.getValue(), (ApplicationVersion)applicationVersionComboBox.getValue());
            entityModelBuilder.setCustomFilter(filter);
        };
        logLeveComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        userComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        exceptionClassComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        applicationComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        perspectiveComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        applicationVersionComboBox.onValueChanged.addListener(value -> onFilterChange.run());
        entityModelBuilder.getOnSelectionEvent().addListener(log -> {
            managedApplicationFormField.setValue((Object)log.getManagedApplication());
            applicationFormField.setValue((Object)log.getApplication());
            perspectiveFormField.setValue((Object)log.getManagedPerspective());
            logLevelFormField.setValue((Object)log.getLogLevel());
            userFormField.setValue(log.getMetaCreatedBy() > 0 ? User.getById(log.getMetaCreatedBy()) : null);
            exceptionClassFormField.setValue((Object)log.getExceptionClass());
            messageFormField.setValue((Object)log.getMessage());
            detailsFormField.setValue((Object)log.getDetails());
            timeFormField.setValue((Object)log.getMetaCreationDate());
        });
    }

    private Predicate<SystemLog> createFilter(LogLevel logLevel, User user, String exceptionClass, ManagedApplication managedApplication, ManagedApplicationPerspective managedApplicationPerspective, ApplicationVersion applicationVersion) {
        if (logLevel == null && managedApplication == null && managedApplicationPerspective == null && applicationVersion == null && user == null && exceptionClass == null) {
            return null;
        }
        return systemLog -> {
            if (logLevel != null && !logLevel.equals((Object)systemLog.getLogLevel())) {
                return false;
            }
            if (user != null && systemLog.getMetaCreatedBy() != user.getId()) {
                return false;
            }
            if (exceptionClass != null && !exceptionClass.equals(systemLog.getExceptionClass())) {
                return false;
            }
            if (managedApplication != null && !managedApplication.equals(systemLog.getManagedApplication())) {
                return false;
            }
            if (managedApplicationPerspective != null && !managedApplicationPerspective.equals(systemLog.getManagedPerspective())) {
                return false;
            }
            return applicationVersion == null || applicationVersion.equals(systemLog.getApplicationVersion());
        };
    }

    private ComboBox<LogLevel> createLogLeveComboBox() {
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(Arrays.asList(LogLevel.values()), this.createLogLevelPropertyProvider(), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        return comboBox;
    }

    private ComboBox<User> createUserComboBox() {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setPropertyProvider(PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        comboBox.setRecordToStringFunction(user -> user.getFirstName() + " " + user.getLastName());
        comboBox.setModel(query -> query == null || query.isBlank() ? User.getAll().stream().limit(50L).collect(Collectors.toList()) : User.filter().parseFullTextFilter(query, new String[0]).execute().stream().limit(50L).collect(Collectors.toList()));
        return comboBox;
    }

    private ComboBox<String> createExceptionClassComboBox() {
        HashSet exceptionClasses = new HashSet();
        SystemLog.getAll().forEach(log -> {
            if (log.getExceptionClass() != null) {
                exceptionClasses.add(log.getExceptionClass());
            }
        });
        return ComboBoxUtils.createRecordComboBox(new ArrayList(exceptionClasses), PropertyProviders.createStringPropertyProvider(ApplicationIcons.BUG), (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    private PropertyProvider<LogLevel> createLogLevelPropertyProvider() {
        return (logLevel, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getLoglevelIcon((LogLevel)((Object)logLevel)));
            map.put("caption", logLevel.name());
            return map;
        };
    }

    private PropertyProvider<SystemLog> createSystemLogPropertyProvider() {
        return (log, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getLoglevelIcon(log.getLogLevel()));
            map.put("caption", log.getMessage());
            return map;
        };
    }

    private Icon getLoglevelIcon(LogLevel level) {
        return switch (level) {
            case LogLevel.INFO -> ApplicationIcons.INFORMATION;
            case LogLevel.WARNING -> ApplicationIcons.SIGN_WARNING;
            case LogLevel.ERROR -> ApplicationIcons.DELETE;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

