/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.systenconfig;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.session.PerspectiveSessionData;
import org.teamapps.application.server.system.session.UserSessionData;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class ApplicationConfigurationPerspective
extends AbstractManagedApplicationPerspective {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final UserSessionData userSessionData;
    private final TwoWayBindableValue<Application> selectedApplication = TwoWayBindableValue.create();

    public ApplicationConfigurationPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        PerspectiveSessionData perspectiveSessionData = (PerspectiveSessionData)this.getApplicationInstanceData();
        this.userSessionData = perspectiveSessionData.getManagedApplicationSessionData().getUserSessionData();
        this.createUi();
    }

    private void createUi() {
        View detailsView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.CODE_LINE, (String)this.getLocalized("applicationConfiguration.title"), null));
        if (!this.isAppFilter()) {
            View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.CODE_LINE, (String)this.getLocalized("applications.title"), null));
            EntityModelBuilder entityModelBuilder = new EntityModelBuilder(Application::filter, this.getApplicationInstanceData());
            Table applicationsTable = entityModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES, PropertyProviders.createApplicationPropertyProvider(this.userSessionData), 60);
            entityModelBuilder.attachSearchField(masterView);
            entityModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("org.teamapps.dictionary.applications"));
            entityModelBuilder.getOnSelectionEvent().addListener(arg_0 -> this.selectedApplication.set(arg_0));
            entityModelBuilder.updateModels();
            masterView.setComponent((Component)applicationsTable);
        }
        MultiLineTextField configField = new MultiLineTextField();
        detailsView.setComponent((Component)configField);
        ToolbarButtonGroup buttonGroup = detailsView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.FLOPPY_DISKS, (String)this.getLocalized("org.teamapps.dictionary.saveChanges"), (String)this.getLocalized("applicationConfiguration.updateApplicationConfiguration")));
        saveButton.onClick.addListener(() -> {
            Application application = (Application)this.selectedApplication.get();
            String configXml = (String)configField.getValue();
            if (application == null || configXml == null || configXml.isBlank()) {
                return;
            }
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication(application);
            try {
                loadedApplication.getBaseApplicationBuilder().updateConfig(configXml, loadedApplication.getApplicationClassLoaderOrDefault());
                application.setConfig(configXml).save();
            }
            catch (Exception e) {
                UiUtils.showNotification((Icon)ApplicationIcons.ERROR, (String)e.getMessage());
                LOGGER.error("ERROR UPDATING APPLICATION CONFIG: " + application.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        });
        this.selectedApplication.onChanged().addListener(application -> {
            LoadedApplication loadedApplication = this.userSessionData.getRegistry().getLoadedApplication((Application)application);
            String xml = loadedApplication.getBaseApplicationBuilder().getApplicationConfigXml(loadedApplication.getApplicationClassLoaderOrDefault());
            configField.setValue((Object)xml);
        });
        if (this.isAppFilter()) {
            this.selectedApplication.set((Object)this.getMainApplication());
        }
    }
}

