/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.translations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.teamapps.application.server.controlcenter.translations.TranslationWorkState;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.MachineTranslationState;
import org.teamapps.model.controlcenter.TranslationState;
import org.teamapps.model.controlcenter.TranslationVerificationState;

public class TranslationUtils {
    public static Predicate<LocalizationKey> getFilterPredicate(TranslationWorkState workState, String language, LocalizationTopic topic) {
        if (workState == null || language == null) {
            return null;
        }
        return switch (workState) {
            case TranslationWorkState.ALL -> TranslationUtils.createFilterPredicate(language, topic, null, null, null);
            case TranslationWorkState.CORRECTIONS_REQUIRED -> TranslationUtils.createFilterPredicate(language, topic, null, TranslationUtils.createTranslationStates(TranslationState.TRANSLATION_REQUESTED), TranslationUtils.createVerificationStates(TranslationVerificationState.CORRECTIONS_REQUIRED));
            case TranslationWorkState.TRANSLATION_REQUIRED -> TranslationUtils.createFilterPredicate(language, topic, null, TranslationUtils.createTranslationStates(TranslationState.TRANSLATION_REQUESTED), null);
            case TranslationWorkState.VERIFICATION_REQUIRED -> TranslationUtils.createFilterPredicate(language, topic, null, TranslationUtils.createTranslationStates(TranslationState.OK), TranslationUtils.createVerificationStates(TranslationVerificationState.VERIFICATION_REQUESTED));
            case TranslationWorkState.VERIFIED -> TranslationUtils.createFilterPredicate(language, topic, null, null, TranslationUtils.createVerificationStates(TranslationVerificationState.OK));
            case TranslationWorkState.UNCLEAR -> TranslationUtils.createFilterPredicate(language, topic, null, TranslationUtils.createTranslationStates(TranslationState.UNCLEAR), null);
            case TranslationWorkState.TRANSLATION_NOT_NECESSARY -> TranslationUtils.createFilterPredicate(language, topic, null, TranslationUtils.createTranslationStates(TranslationState.NOT_NECESSARY), null);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static Predicate<LocalizationKey> createFilterPredicate(String language, LocalizationTopic topic, Set<MachineTranslationState> machineTranslationStates, Set<TranslationState> translationStates, Set<TranslationVerificationState> verificationStates) {
        return key -> {
            if (topic != null && !key.getTopics().contains(topic)) {
                return false;
            }
            LocalizationValue value = TranslationUtils.getValue(key, language);
            if (value == null) {
                return false;
            }
            if (machineTranslationStates != null && !machineTranslationStates.contains((Object)value.getMachineTranslationState())) {
                return false;
            }
            if (translationStates != null && !translationStates.contains((Object)value.getTranslationState())) {
                return false;
            }
            return verificationStates == null || verificationStates.contains((Object)value.getTranslationVerificationState());
        };
    }

    public static Set<MachineTranslationState> createMachineStates(MachineTranslationState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        return new HashSet<MachineTranslationState>(Arrays.asList(states));
    }

    public static Set<TranslationState> createTranslationStates(TranslationState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        return new HashSet<TranslationState>(Arrays.asList(states));
    }

    public static Set<TranslationVerificationState> createVerificationStates(TranslationVerificationState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        return new HashSet<TranslationVerificationState>(Arrays.asList(states));
    }

    public static LocalizationValue getValue(LocalizationKey key, String language) {
        if (key == null) {
            return null;
        }
        return key.getLocalizationValues().stream().filter(value -> language.equals(value.getLanguage())).findAny().orElse(null);
    }

    public static String getDisplayValue(LocalizationKey key, String language) {
        LocalizationValue value = TranslationUtils.getValue(key, language);
        return value != null ? value.getCurrentDisplayValue() : null;
    }

    public static String getDisplayValueNonNull(LocalizationKey key, String language) {
        String value = TranslationUtils.getDisplayValue(key, language);
        return value != null ? value : "";
    }

    public static Map<String, LocalizationValue> getValueMap(LocalizationKey key) {
        return key.getLocalizationValues().stream().collect(Collectors.toMap(LocalizationValue::getLanguage, k -> k));
    }
}

