/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.messaging.newsboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.config.LocalizationConfig;
import org.teamapps.application.server.system.machinetranslation.TranslationService;
import org.teamapps.application.ux.form.FormWindow;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.NewsBoardMessage;
import org.teamapps.model.controlcenter.NewsBoardMessageTranslation;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;

public class TranslationSelectionDialogue
extends FormWindow {
    private final NewsBoardMessage message;
    private final boolean translateAll;
    private final LocalizationConfig localizationConfig;
    private final TranslationService translationService;
    private final Runnable runOnSuccess;

    public TranslationSelectionDialogue(NewsBoardMessage message, boolean translateAll, LocalizationConfig localizationConfig, TranslationService translationService, Runnable runOnSuccess, ApplicationInstanceData applicationInstanceData) {
        super(ApplicationIcons.EARTH, applicationInstanceData.getLocalized("newsBoard.translations", new Object[0]), applicationInstanceData);
        this.message = message;
        this.translateAll = translateAll;
        this.localizationConfig = localizationConfig;
        this.translationService = translationService;
        this.runOnSuccess = runOnSuccess;
        this.createUi();
    }

    private void createUi() {
        ComboBox languageComboBox = Language.createComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        Language originalLanguage = Language.getLanguageByIsoCode((String)this.message.getLanguage());
        languageComboBox.setValue((Object)originalLanguage);
        Set availableLanguages = this.message.getTranslations().stream().map(translation -> Language.getLanguageByIsoCode((String)translation.getLanguage())).filter(Objects::nonNull).collect(Collectors.toSet());
        if (originalLanguage != null) {
            availableLanguages.add(originalLanguage);
        }
        List translatableLanguages = this.localizationConfig.getRequiredLanguages().stream().map(Language::getLanguageByIsoCode).filter(Objects::nonNull).collect(Collectors.toList());
        List allowedLanguages = translatableLanguages.stream().filter(language -> !availableLanguages.contains(language)).collect(Collectors.toList());
        TagComboBox languageTagComboBox = Language.createTagComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData(), new HashSet(allowedLanguages));
        languageTagComboBox.setDistinct(true);
        if (this.translateAll) {
            languageTagComboBox.setValue(allowedLanguages);
        }
        this.addField(this.getLocalized("newsBoard.originalLanguage", new Object[0]), (Component)languageComboBox);
        this.addField(this.getLocalized("newsBoard.translationLanguages", new Object[0]), (Component)languageTagComboBox);
        this.addOkButton();
        this.addButtonGroup();
        this.addButton((Icon)ApplicationIcons.ADD, (String)this.getLocalized((String)"newsBoard.addAllLanguages", (Object[])new Object[0])).onClick.addListener(() -> languageTagComboBox.setValue(null));
        this.addButton((Icon)ApplicationIcons.DELETE, (String)this.getLocalized((String)"newsBoard.removeLanguages", (Object[])new Object[0])).onClick.addListener(() -> languageTagComboBox.setValue(allowedLanguages));
        this.addButtonGroup();
        this.addCancelButton();
        this.getOkButton().onClick.addListener(() -> {
            Language mainLanguage = (Language)languageComboBox.getValue();
            List translationLanguages = (List)languageTagComboBox.getValue();
            if (this.message.getHtmlMessage() != null && this.translationService != null && mainLanguage != null && translationLanguages != null && !translationLanguages.isEmpty()) {
                this.message.save();
                this.runTaskAsync(ApplicationIcons.GEARWHEELS, this.getLocalized("newsBoard.translatingMessage__", new Object[0]), () -> {
                    this.translateMessage(mainLanguage, translationLanguages);
                    return true;
                }, result -> this.runOnSuccess.run());
                this.close();
            }
        });
        this.show();
    }

    private void translateMessage(Language original, List<Language> languages) {
        String originalMessage = this.message.getHtmlMessage();
        if (originalMessage.isBlank()) {
            return;
        }
        try {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (Language language : languages) {
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.translate(original, language, originalMessage));
                futures.add(future);
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            completableFuture.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void translate(Language src, Language dst, String value) {
        String translatedMessage = this.translationService.translate(value, src.getIsoCode(), dst.getIsoCode());
        System.out.println("Translated message " + dst.getIsoCode() + ":" + translatedMessage);
        if (translatedMessage != null) {
            NewsBoardMessageTranslation.create().setMessage(this.message).setTranslation(translatedMessage).setLanguage(dst.getIsoCode()).save();
        }
    }
}

