/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.messaging.newsboard.views;

import java.util.Collections;
import java.util.List;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.server.messaging.newsboard.NewsBoardUtils;
import org.teamapps.application.tools.RecordListModelBuilder;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.event.Event;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class LanguageSelectionView
extends AbstractApplicationView {
    public Event<String> onLanguageSelection = new Event();
    private Table<String> table;
    private final RecordListModelBuilder<String> modelBuilder;

    public LanguageSelectionView(ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        PropertyProvider<String> propertyProvider = NewsBoardUtils.createLanguageSelectionPropertyProvider(applicationInstanceData);
        this.modelBuilder = new RecordListModelBuilder(applicationInstanceData);
        this.modelBuilder.setRecordStringFunction(s -> (String)propertyProvider.getValues(s, null).get("caption"));
        this.table = this.modelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE, propertyProvider, 30);
        this.modelBuilder.getOnSelectionEvent().addListener(language -> this.onLanguageSelection.fire(language));
    }

    public Component getComponent() {
        return this.table;
    }

    public void setOwnLanguage() {
        this.modelBuilder.setRecords(Collections.singletonList("user-languages"));
    }

    public void setLanguages(List<String> languages) {
        this.modelBuilder.setRecords(languages);
    }
}

