/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.messaging.newsboard.views;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.messaging.newsboard.views.ViewMessageHandler;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.model.controlcenter.NewsBoardMessage;
import org.teamapps.model.controlcenter.User;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.pageview.AbstractPageViewBlock;
import org.teamapps.ux.component.pageview.MessagePageViewBlock;
import org.teamapps.ux.component.pageview.PageView;
import org.teamapps.ux.component.pageview.PageViewBlockAlignment;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbutton.ToolButton;
import org.teamapps.ux.session.SessionContext;

public class MessageView
extends AbstractApplicationView {
    private final List<String> preferredLanguages;
    private final ViewMessageHandler viewMessageHandler;
    private PageView pageView;

    public MessageView(NewsBoardMessage message, ApplicationInstanceData applicationInstanceData, List<String> preferredLanguages, ViewMessageHandler viewMessageHandler) {
        this(Collections.singletonList((Object)message), applicationInstanceData, preferredLanguages, viewMessageHandler);
    }

    public MessageView(List<NewsBoardMessage> messages, ApplicationInstanceData applicationInstanceData, List<String> preferredLanguages, ViewMessageHandler viewMessageHandler) {
        super(applicationInstanceData);
        this.preferredLanguages = preferredLanguages;
        this.viewMessageHandler = viewMessageHandler;
        this.pageView = new PageView();
        messages.forEach(message -> this.addMessageBlock((NewsBoardMessage)message, this.pageView));
    }

    public Component getComponent() {
        return this.pageView;
    }

    private void addMessageBlock(NewsBoardMessage message, PageView pageView) {
        MessagePageViewBlock messageBlock = new MessagePageViewBlock(PageViewBlockAlignment.FULL, (Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES, (Object)User.getById(message.getMetaCreatedBy()));
        messageBlock.setTopRecordAlignment(HorizontalElementAlignment.STRETCH);
        messageBlock.setTopRecordPropertyProvider(PropertyProviders.createUserPropertyProvider(this.getApplicationInstanceData()));
        if (this.viewMessageHandler != null) {
            ArrayList<ToolButton> toolButtons = new ArrayList<ToolButton>();
            ToolButton toolButton = new ToolButton(ApplicationIcons.RADIO_BUTTON_GROUP);
            toolButton.onClick.addListener(() -> this.viewMessageHandler.handleViewMessageRequest(message));
            toolButtons.add(toolButton);
            messageBlock.setToolButtons(toolButtons);
        }
        HashMap<String, String> messageByLanguage = new HashMap<String, String>();
        messageByLanguage.put(message.getLanguage(), message.getHtmlMessage());
        message.getTranslations().forEach(translation -> messageByLanguage.put(translation.getLanguage(), translation.getTranslation()));
        Object htmlMessage = message.getHtmlMessage();
        for (String language : this.preferredLanguages) {
            String value = (String)messageByLanguage.get(language);
            if (value == null) continue;
            htmlMessage = value;
            break;
        }
        if (!message.isPublished()) {
            htmlMessage = "<p style=\"border-style:solid;border-color:#f07d00;border-width:1px;background-color:#ffe3c9;padding:2px\">" + this.getLocalized("newsBoard.messageIsNotYetPublished", new Object[0]) + "</p>" + (String)htmlMessage;
        }
        messageBlock.setHtml((String)htmlMessage);
        SessionContext context = SessionContext.current();
        List images = message.getImages().stream().filter(image -> image.getFile() != null).map(image -> context.createFileLink(image.getFile().retrieveFile())).collect(Collectors.toList());
        messageBlock.setImageUrls(images);
        pageView.addBlock((AbstractPageViewBlock)messageBlock);
    }
}

