/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.settings;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.perspective.AbstractApplicationPerspective;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.User;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;

public class UserLanguageSettingsPerspective
extends AbstractApplicationPerspective {
    public UserLanguageSettingsPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        Perspective perspective = this.getPerspective();
        View view = perspective.addView(View.createView((String)"center", (Icon)ApplicationIcons.DICTIONARY, (String)this.getLocalized("org.teamapps.dictionary.language"), null));
        view.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        User user = User.getById(this.getApplicationInstanceData().getUser().getId());
        ComboBox languageComboBox = Language.createComboBox((ApplicationLocalizationProvider)this.getApplicationInstanceData());
        Language language = Language.getLanguageByIsoCode((String)this.getApplicationInstanceData().getUser().getLanguage());
        languageComboBox.setValue((Object)language);
        Button saveButton = Button.create((Icon)ApplicationIcons.OK, (String)this.getLocalized("org.teamapps.dictionary.save"));
        ResponsiveForm form = new ResponsiveForm(100, 150, 250);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection(null, null).setDrawHeaderLine(false).setCollapsible(false);
        formLayout.addLabelAndField(null, this.getLocalized("org.teamapps.dictionary.language"), (AbstractField)languageComboBox);
        formLayout.addLabelAndField((AbstractField)saveButton);
        view.setComponent((Component)form);
        saveButton.onClicked.addListener(() -> {
            Language lang = (Language)languageComboBox.getValue();
            if (lang != null) {
                user.setLanguages(lang.getIsoCode()).save();
                UiUtils.showSaveNotification((boolean)true, (ApplicationInstanceData)this.getApplicationInstanceData());
            }
        });
    }
}

