/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.model.controlcenter.ApplicationVersionData;

public class ApplicationInfoDataElement {
    private String data;
    private List<String> dataAdded = new ArrayList<String>();
    private List<String> dataRemoved = new ArrayList<String>();

    public static String getChangeString(ApplicationVersionData versionData) {
        return versionData != null ? "+ " + versionData.getDataAddedRows() + " | - " + versionData.getDataRemovedRows() : null;
    }

    public static String getMultiLineChangeHtml(ApplicationVersionData versionData, String addedTitle, String removedTitle) {
        if (versionData == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(addedTitle).append("</b>:<br>");
        sb.append(versionData.getDataAdded() != null ? versionData.getDataAdded().replace("\n", "<br>") : "");
        sb.append("<br><b>").append(removedTitle).append("</b>:<br>");
        sb.append(versionData.getDataRemoved() != null ? versionData.getDataRemoved().replace("\n", "<br>") : "");
        return sb.toString();
    }

    public String getChangeString() {
        return "+ " + this.dataAdded.size() + " | - " + this.dataRemoved.size();
    }

    public String getMultiLineChangeHtml(String addedTitle, String removedTitle) {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(addedTitle).append("</b>:<br>");
        this.dataAdded.forEach(v -> sb.append((String)v).append("<br>"));
        sb.append("<br><b>").append(removedTitle).append("</b>:<br>");
        this.dataRemoved.forEach(v -> sb.append((String)v).append("<br>"));
        return sb.toString();
    }

    public void added(String element) {
        this.dataAdded.add(element);
    }

    public void removed(String element) {
        this.dataRemoved.add(element);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<String> getDataAdded() {
        return this.dataAdded;
    }

    public void setDataAdded(List<String> dataAdded) {
        this.dataAdded = dataAdded;
    }

    public List<String> getDataRemoved() {
        return this.dataRemoved;
    }

    public void setDataRemoved(List<String> dataRemoved) {
        this.dataRemoved = dataRemoved;
    }

    public String toString() {
        return "ApplicationInfoDataElement{data='" + this.data + "', dataAdded=" + this.dataAdded + ", dataRemoved=" + this.dataRemoved + "}";
    }
}

