/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.bootstrap;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.server.chat.ChatApplication;
import org.teamapps.application.server.controlcenter.ControlCenterAppBuilder;
import org.teamapps.application.server.messaging.MessagingApplication;
import org.teamapps.application.server.settings.UserSettingsApp;
import org.teamapps.application.server.system.auth.LoginHandler;
import org.teamapps.application.server.system.bootstrap.LogoutHandler;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.bootstrap.installer.ApplicationInstaller;
import org.teamapps.application.server.system.config.SystemConfig;
import org.teamapps.application.server.system.logging.DatabaseLogAppender;
import org.teamapps.application.server.system.server.SessionHandler;
import org.teamapps.application.server.system.server.SessionManager;
import org.teamapps.application.server.system.server.SessionRegistryHandler;
import org.teamapps.application.server.system.template.Templates;
import org.teamapps.event.Event;
import org.teamapps.icon.antu.AntuIcon;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icon.fontawesome.FontAwesomeIcon;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.model.ControlCenterSchema;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.session.SessionContext;

public class BootstrapSessionHandler
implements SessionHandler,
LogoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Class standardIconClass;
    public Event<SessionContext> onUserLogout = new Event();
    private final SessionRegistryHandler sessionRegistryHandler;
    private SessionManager sessionManager;
    private UniversalDB universalDB;
    private SystemRegistry systemRegistry;
    private ControlCenterAppBuilder controlCenterAppBuilder;

    public BootstrapSessionHandler() {
        this(null);
    }

    public BootstrapSessionHandler(SessionRegistryHandler sessionRegistryHandler) {
        this.sessionRegistryHandler = sessionRegistryHandler;
    }

    public void installNewSystem(File applicationJar) throws Exception {
        this.sessionManager.updateSessionHandler(applicationJar);
    }

    @Override
    public void init(SessionManager sessionManager, UniversalDB universalDB) {
        try {
            this.sessionManager = sessionManager;
            this.universalDB = universalDB;
            this.startSystem();
        }
        catch (Exception e) {
            LOGGER.error("Error initializing system:", (Throwable)e);
        }
    }

    private void startSystem() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ControlCenterSchema schema = new ControlCenterSchema();
        this.universalDB.addAuxiliaryModel((SchemaInfoProvider)schema, classLoader);
        this.universalDB.installAuxiliaryModelClassed((SchemaInfoProvider)schema, classLoader);
        this.universalDB.installTableViews((SchemaInfoProvider)schema, classLoader);
        DatabaseLogAppender.startLogger();
        this.controlCenterAppBuilder = new ControlCenterAppBuilder();
        ApplicationConfig<SystemConfig> applicationConfig = this.controlCenterAppBuilder.getApplicationConfig();
        this.systemRegistry = new SystemRegistry(this, this.universalDB, applicationConfig);
        this.systemRegistry.setSessionRegistryHandler(this.sessionRegistryHandler);
        this.systemRegistry.installAndLoadApplication((BaseApplicationBuilder)this.controlCenterAppBuilder);
        this.systemRegistry.installAndLoadApplication((BaseApplicationBuilder)new UserSettingsApp());
        this.loadSystemApps();
        for (Application application : Application.getAll()) {
            File jarFile;
            ApplicationInstaller jarInstaller;
            ApplicationVersion installedVersion = application.getInstalledVersion();
            if (installedVersion == null) {
                System.out.println("ERROR: app has no installed version:" + application);
                continue;
            }
            FileValue binary = installedVersion.getBinary();
            if (binary == null || !(jarInstaller = ApplicationInstaller.createJarInstaller(jarFile = (File)binary.getFileSupplier().get(), this.universalDB, this.systemRegistry.getTranslationService(), this.systemRegistry.getSystemConfig().getLocalizationConfig())).isInstalled()) continue;
            this.systemRegistry.loadApplication(jarInstaller);
        }
    }

    public void loadSystemApps() {
        this.systemRegistry.installAndLoadApplication((BaseApplicationBuilder)new MessagingApplication());
        this.systemRegistry.installAndLoadApplication((BaseApplicationBuilder)new ChatApplication());
    }

    @Override
    public void handleSessionStart(SessionContext context) {
        if (standardIconClass != null) {
            context.getIconProvider().registerIconLibrary(standardIconClass);
        }
        if (this.sessionRegistryHandler != null) {
            this.sessionRegistryHandler.handleNewSession(context);
        }
        context.getIconProvider().registerIconLibrary(FlagIcon.class);
        context.getIconProvider().registerIconLibrary(MaterialIcon.class);
        context.getIconProvider().registerIconLibrary(FontAwesomeIcon.class);
        context.getIconProvider().registerIconLibrary(AntuIcon.class);
        context.registerTemplates(Arrays.stream(Templates.values()).collect(Collectors.toMap(Enum::name, Templates::getTemplate)));
        new LoginHandler(this.systemRegistry, this).handleNewSession(context);
    }

    @Override
    public void handleLogout(SessionContext context) {
    }

    public UniversalDB getUniversalDB() {
        return this.universalDB;
    }

    public SystemRegistry getSystemRegistry() {
        return this.systemRegistry;
    }

    public ControlCenterAppBuilder getControlCenterAppBuilder() {
        return this.controlCenterAppBuilder;
    }

    static {
        try {
            standardIconClass = Class.forName("org.teamapps.icon.standard.StandardIcon");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

