/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.machinetranslation;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.server.system.machinetranslation.TranslationService;

public class GoogleTranslation
implements TranslationService {
    private Translate translationService;
    private long translatedCharacters = 0L;
    private Set<String> supportedLanguages;

    public GoogleTranslation(String key) throws IOException {
        this.initialize(key);
    }

    private void initialize(String key) throws IOException {
        this.translationService = (Translate)((TranslateOptions.Builder)TranslateOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8))))).build().getService();
    }

    @Override
    public Set<String> getSupportedLanguages() {
        if (this.supportedLanguages != null && !this.supportedLanguages.isEmpty()) {
            return this.supportedLanguages;
        }
        List languages = this.translationService.listSupportedLanguages(new Translate.LanguageListOption[0]);
        this.supportedLanguages = languages.stream().map(Language::getCode).collect(Collectors.toSet());
        return this.supportedLanguages;
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) {
        Translation translation = this.translationService.translate(text, new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)sourceLanguage), Translate.TranslateOption.targetLanguage((String)targetLanguage)});
        String translatedText = translation.getTranslatedText();
        if (translatedText != null) {
            this.translatedCharacters += (long)translatedText.length();
        }
        return translatedText;
    }

    @Override
    public long getTranslatedCharacters() {
        return this.translatedCharacters;
    }
}

