/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.Objects;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.RoleApplicationRoleAssignment;
import org.teamapps.model.controlcenter.RolePrivilegeAssignment;

public class PrivilegeApplicationKey {
    private final String key;
    private final Application application;
    private final OrganizationFieldView organizationFieldView;

    public static PrivilegeApplicationKey create(ManagedApplicationPerspective perspective) {
        OrganizationField organizationField = perspective.getManagedApplication().getOrganizationField();
        OrganizationFieldView organizationFieldView = OrganizationUtils.convert(organizationField);
        Application application = perspective.getApplicationPerspective().getApplication();
        if (application == null) {
            return null;
        }
        return new PrivilegeApplicationKey(application, organizationFieldView);
    }

    public static PrivilegeApplicationKey createUnmanagedKey(ManagedApplication managedApplication) {
        return new PrivilegeApplicationKey(managedApplication.getMainApplication(), null);
    }

    public static PrivilegeApplicationKey create(ManagedApplication managedApplication) {
        return new PrivilegeApplicationKey(managedApplication.getMainApplication(), null);
    }

    public static PrivilegeApplicationKey create(RoleApplicationRoleAssignment roleApplicationRoleAssignment) {
        return new PrivilegeApplicationKey(roleApplicationRoleAssignment.getApplication(), OrganizationUtils.convert(roleApplicationRoleAssignment.getOrganizationFieldFilter()));
    }

    public static PrivilegeApplicationKey create(RolePrivilegeAssignment privilegeAssignment) {
        return new PrivilegeApplicationKey(privilegeAssignment.getApplication(), OrganizationUtils.convert(privilegeAssignment.getOrganizationFieldFilter()));
    }

    private PrivilegeApplicationKey(Application application, OrganizationFieldView organizationFieldView) {
        this.application = application;
        this.organizationFieldView = organizationFieldView;
        this.key = organizationFieldView != null ? application.getId() + "-" + organizationFieldView.getId() : "" + application.getId();
    }

    public Application getApplication() {
        return this.application;
    }

    public OrganizationFieldView getOrganizationFieldView() {
        return this.organizationFieldView;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeApplicationKey that = (PrivilegeApplicationKey)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

