/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.privilege;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.server.system.bootstrap.LoadedApplication;
import org.teamapps.application.server.system.bootstrap.SystemRegistry;
import org.teamapps.application.server.system.organization.OrganizationUtils;
import org.teamapps.application.server.system.privilege.AllowAllPrivilegeProvider;
import org.teamapps.application.server.system.privilege.ApplicationScopePrivilegeProvider;
import org.teamapps.application.server.system.privilege.PrivilegeApplicationKey;
import org.teamapps.application.server.system.privilege.UserApplicationPrivilege;
import org.teamapps.application.server.system.utils.RoleUtils;
import org.teamapps.application.server.system.utils.ValueConverterUtils;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPrivilege;
import org.teamapps.model.controlcenter.OrganizationUnit;
import org.teamapps.model.controlcenter.OrganizationUnitType;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.Role;
import org.teamapps.model.controlcenter.RoleApplicationRoleAssignment;
import org.teamapps.model.controlcenter.RolePrivilegeAssignment;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserAccountStatus;
import org.teamapps.model.controlcenter.UserRoleAssignment;

public class UserPrivileges {
    private final User user;
    private final SystemRegistry systemRegistry;
    private final Map<PrivilegeApplicationKey, Set<SimplePrivilege>> simplePrivilegesMap = new HashMap<PrivilegeApplicationKey, Set<SimplePrivilege>>();
    private final Map<PrivilegeApplicationKey, Map<SimpleOrganizationalPrivilege, Set<OrganizationUnitView>>> simpleOrganizationPrivilegeMap = new HashMap<PrivilegeApplicationKey, Map<SimpleOrganizationalPrivilege, Set<OrganizationUnitView>>>();
    private final Map<PrivilegeApplicationKey, Map<SimpleCustomObjectPrivilege, Set<PrivilegeObject>>> simpleCustomObjectPrivilegeMap = new HashMap<PrivilegeApplicationKey, Map<SimpleCustomObjectPrivilege, Set<PrivilegeObject>>>();
    private final Map<PrivilegeApplicationKey, Map<StandardPrivilegeGroup, Set<Privilege>>> standardPrivilegeMap = new HashMap<PrivilegeApplicationKey, Map<StandardPrivilegeGroup, Set<Privilege>>>();
    private final Map<PrivilegeApplicationKey, Map<OrganizationalPrivilegeGroup, Map<Privilege, Set<OrganizationUnitView>>>> organizationPrivilegeGroupMap = new HashMap<PrivilegeApplicationKey, Map<OrganizationalPrivilegeGroup, Map<Privilege, Set<OrganizationUnitView>>>>();
    private final Map<PrivilegeApplicationKey, Map<CustomObjectPrivilegeGroup, Map<Privilege, Set<PrivilegeObject>>>> customObjectPrivilegeGroupMap = new HashMap<PrivilegeApplicationKey, Map<CustomObjectPrivilegeGroup, Map<Privilege, Set<PrivilegeObject>>>>();
    private final Map<PrivilegeApplicationKey, UserApplicationPrivilege> userApplicationPrivilegeByApplication = new HashMap<PrivilegeApplicationKey, UserApplicationPrivilege>();

    public UserPrivileges(User user, SystemRegistry systemRegistry) {
        this.user = user;
        this.systemRegistry = systemRegistry;
        this.calculatePrivileges();
    }

    public Set<PrivilegeApplicationKey> getKeys() {
        HashSet<PrivilegeApplicationKey> keySet = new HashSet<PrivilegeApplicationKey>();
        keySet.addAll(this.simplePrivilegesMap.keySet());
        keySet.addAll(this.simpleOrganizationPrivilegeMap.keySet());
        keySet.addAll(this.simpleCustomObjectPrivilegeMap.keySet());
        keySet.addAll(this.standardPrivilegeMap.keySet());
        keySet.addAll(this.organizationPrivilegeGroupMap.keySet());
        keySet.addAll(this.customObjectPrivilegeGroupMap.keySet());
        return keySet;
    }

    public List<Application> getApplications() {
        return this.getKeys().stream().map(PrivilegeApplicationKey::getApplication).collect(Collectors.toList());
    }

    public Map<Application, List<PrivilegeApplicationKey>> getApplicationKeyMap() {
        return this.getKeys().stream().collect(Collectors.groupingBy(PrivilegeApplicationKey::getApplication));
    }

    public List<PrivilegeGroup> getPrivilegeGroups(PrivilegeApplicationKey applicationKey) {
        ArrayList<PrivilegeGroup> groups = new ArrayList<PrivilegeGroup>();
        if (this.simplePrivilegesMap.containsKey(applicationKey)) {
            groups.addAll((Collection)this.simplePrivilegesMap.get(applicationKey));
        }
        if (this.simpleOrganizationPrivilegeMap.containsKey(applicationKey)) {
            groups.addAll(this.simpleOrganizationPrivilegeMap.get(applicationKey).keySet());
        }
        if (this.simpleCustomObjectPrivilegeMap.containsKey(applicationKey)) {
            groups.addAll(this.simpleCustomObjectPrivilegeMap.get(applicationKey).keySet());
        }
        if (this.standardPrivilegeMap.containsKey(applicationKey)) {
            groups.addAll(this.standardPrivilegeMap.get(applicationKey).keySet());
        }
        if (this.organizationPrivilegeGroupMap.containsKey(applicationKey)) {
            groups.addAll(this.organizationPrivilegeGroupMap.get(applicationKey).keySet());
        }
        if (this.customObjectPrivilegeGroupMap.containsKey(applicationKey)) {
            groups.addAll(this.customObjectPrivilegeGroupMap.get(applicationKey).keySet());
        }
        return groups;
    }

    private void calculatePrivileges() {
        for (UserRoleAssignment roleAssignment : this.user.getRoleAssignments()) {
            Role role = roleAssignment.getRole();
            OrganizationUnit organizationUnit = roleAssignment.getOrganizationUnit();
            Set<Role> privilegeRoles = RoleUtils.getAllPrivilegeRoles(role);
            for (Role privilegeRole : privilegeRoles) {
                for (RoleApplicationRoleAssignment roleApplicationRoleAssignment : privilegeRole.getApplicationRoleAssignments()) {
                    this.calculatePrivilegesFromApplicationRoleAssignment(organizationUnit, roleApplicationRoleAssignment);
                }
                for (RolePrivilegeAssignment privilegeAssignment : privilegeRole.getPrivilegeAssignments()) {
                    this.calculatePrivilegesFromRolePrivilegeAssignment(organizationUnit, privilegeAssignment);
                }
            }
        }
    }

    private void calculatePrivilegesFromApplicationRoleAssignment(OrganizationUnit organizationUnit, RoleApplicationRoleAssignment roleApplicationRoleAssignment) {
        try {
            ApplicationRole applicationRole;
            Application application = roleApplicationRoleAssignment.getApplication();
            String applicationRoleName = roleApplicationRoleAssignment.getApplicationRoleName();
            PrivilegeApplicationKey privilegeApplicationKey = PrivilegeApplicationKey.create(roleApplicationRoleAssignment);
            OrganizationUnit fixedOrganizationRoot = roleApplicationRoleAssignment.getFixedOrganizationRoot();
            List<OrganizationUnitType> organizationUnitTypeFilter = roleApplicationRoleAssignment.getOrganizationUnitTypeFilter();
            LoadedApplication loadedApplication = this.systemRegistry.getLoadedApplication(application);
            if (loadedApplication != null && (applicationRole = loadedApplication.getAppPrivilegeProvider().getApplicationRole(applicationRoleName)) != null && applicationRole.getPrivilegeGroups() != null) {
                Set<OrganizationUnit> allUnits = OrganizationUtils.getAllUnits(fixedOrganizationRoot != null ? fixedOrganizationRoot : organizationUnit, organizationUnitTypeFilter);
                List<OrganizationUnitView> organizationUnitViews = OrganizationUtils.convertList(allUnits);
                List privilegeGroups = applicationRole.getPrivilegeGroups();
                block10: for (PrivilegeGroup privilegeGroup : privilegeGroups) {
                    switch (privilegeGroup.getType()) {
                        case SIMPLE_PRIVILEGE: {
                            SimplePrivilege simplePrivilege = (SimplePrivilege)privilegeGroup;
                            this.simplePrivilegesMap.computeIfAbsent(privilegeApplicationKey, app -> new HashSet()).add(simplePrivilege);
                            break;
                        }
                        case SIMPLE_ORGANIZATIONAL_PRIVILEGE: {
                            SimpleOrganizationalPrivilege simpleOrganizationalPrivilege = (SimpleOrganizationalPrivilege)privilegeGroup;
                            this.simpleOrganizationPrivilegeMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(simpleOrganizationalPrivilege, s -> new HashSet()).addAll(organizationUnitViews);
                            break;
                        }
                        case SIMPLE_CUSTOM_OBJECT_PRIVILEGE: {
                            SimpleCustomObjectPrivilege simpleCustomObjectPrivilege = (SimpleCustomObjectPrivilege)privilegeGroup;
                            List privilegeObjects = (List)simpleCustomObjectPrivilege.getPrivilegeObjectsSupplier().get();
                            this.simpleCustomObjectPrivilegeMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(simpleCustomObjectPrivilege, s -> new HashSet()).addAll(privilegeObjects);
                            break;
                        }
                        case STANDARD_PRIVILEGE_GROUP: {
                            StandardPrivilegeGroup standardPrivilegeGroup = (StandardPrivilegeGroup)privilegeGroup;
                            List privileges = privilegeGroup.getPrivileges();
                            this.standardPrivilegeMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(standardPrivilegeGroup, s -> new HashSet()).addAll(privileges);
                            break;
                        }
                        case ORGANIZATIONAL_PRIVILEGE_GROUP: {
                            OrganizationalPrivilegeGroup organizationalPrivilegeGroup = (OrganizationalPrivilegeGroup)privilegeGroup;
                            List groupPrivileges = privilegeGroup.getPrivileges();
                            Map organizationUnitViewsByPrivilege = this.organizationPrivilegeGroupMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(organizationalPrivilegeGroup, s -> new HashMap());
                            for (Privilege privilege : groupPrivileges) {
                                organizationUnitViewsByPrivilege.computeIfAbsent(privilege, p -> new HashSet()).addAll(organizationUnitViews);
                            }
                            continue block10;
                        }
                        case CUSTOM_OBJECT_PRIVILEGE_GROUP: {
                            CustomObjectPrivilegeGroup customObjectPrivilegeGroup = (CustomObjectPrivilegeGroup)privilegeGroup;
                            List customPrivileges = (List)customObjectPrivilegeGroup.getPrivilegeObjectsSupplier().get();
                            List customObjectPrivileges = customObjectPrivilegeGroup.getPrivileges();
                            Map customObjectsByPrivilege = this.customObjectPrivilegeGroupMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(customObjectPrivilegeGroup, c -> new HashMap());
                            for (Privilege privilege : customObjectPrivileges) {
                                customObjectsByPrivilege.computeIfAbsent(privilege, p -> new HashSet()).addAll(customPrivileges);
                            }
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void calculatePrivilegesFromRolePrivilegeAssignment(OrganizationUnit organizationUnit, RolePrivilegeAssignment privilegeAssignment) {
        Application application = privilegeAssignment.getApplication();
        LoadedApplication loadedApplication = this.systemRegistry.getLoadedApplication(application);
        if (loadedApplication != null) {
            ApplicationScopePrivilegeProvider privilegeProvider = loadedApplication.getAppPrivilegeProvider();
            PrivilegeApplicationKey privilegeApplicationKey = PrivilegeApplicationKey.create(privilegeAssignment);
            OrganizationUnit fixedOrganizationRoot = privilegeAssignment.getFixedOrganizationRoot();
            List<OrganizationUnitType> organizationUnitTypeFilter = privilegeAssignment.getOrganizationUnitTypeFilter();
            PrivilegeGroup privilegeGroup = privilegeProvider.getPrivilegeGroup(privilegeAssignment.getPrivilegeGroup().getName());
            List<Privilege> privileges = privilegeProvider.getPrivilegesByNameList(privilegeAssignment.getPrivileges().stream().map(ApplicationPrivilege::getName).collect(Collectors.toList()));
            boolean privilegeObjectInheritance = privilegeAssignment.getPrivilegeObjectInheritance();
            List<Integer> privilegeObjectIdList = ValueConverterUtils.decompressIds(privilegeAssignment.getPrivilegeObjects());
            List<PrivilegeObject> privilegeObjects = privilegeProvider.getPrivilegeObjects(privilegeGroup, privilegeObjectIdList, privilegeObjectInheritance);
            Set<OrganizationUnit> allUnits = OrganizationUtils.getAllUnits(fixedOrganizationRoot != null ? fixedOrganizationRoot : organizationUnit, organizationUnitTypeFilter);
            List<OrganizationUnitView> organizationUnitViews = OrganizationUtils.convertList(allUnits);
            try {
                switch (privilegeGroup.getType()) {
                    case SIMPLE_PRIVILEGE: {
                        SimplePrivilege simplePrivilege = (SimplePrivilege)privilegeGroup;
                        this.simplePrivilegesMap.computeIfAbsent(privilegeApplicationKey, app -> new HashSet()).add(simplePrivilege);
                        break;
                    }
                    case SIMPLE_ORGANIZATIONAL_PRIVILEGE: {
                        SimpleOrganizationalPrivilege simpleOrganizationalPrivilege = (SimpleOrganizationalPrivilege)privilegeGroup;
                        this.simpleOrganizationPrivilegeMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(simpleOrganizationalPrivilege, s -> new HashSet()).addAll(organizationUnitViews);
                        break;
                    }
                    case SIMPLE_CUSTOM_OBJECT_PRIVILEGE: {
                        SimpleCustomObjectPrivilege simpleCustomObjectPrivilege = (SimpleCustomObjectPrivilege)privilegeGroup;
                        this.simpleCustomObjectPrivilegeMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(simpleCustomObjectPrivilege, s -> new HashSet()).addAll(privilegeObjects);
                        break;
                    }
                    case STANDARD_PRIVILEGE_GROUP: {
                        StandardPrivilegeGroup standardPrivilegeGroup = (StandardPrivilegeGroup)privilegeGroup;
                        this.standardPrivilegeMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(standardPrivilegeGroup, s -> new HashSet()).addAll(privileges);
                        break;
                    }
                    case ORGANIZATIONAL_PRIVILEGE_GROUP: {
                        OrganizationalPrivilegeGroup organizationalPrivilegeGroup = (OrganizationalPrivilegeGroup)privilegeGroup;
                        Map organizationUnitViewsByPrivilege = this.organizationPrivilegeGroupMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(organizationalPrivilegeGroup, s -> new HashMap());
                        for (Privilege privilege : privileges) {
                            organizationUnitViewsByPrivilege.computeIfAbsent(privilege, p -> new HashSet()).addAll(organizationUnitViews);
                        }
                        break;
                    }
                    case CUSTOM_OBJECT_PRIVILEGE_GROUP: {
                        CustomObjectPrivilegeGroup customObjectPrivilegeGroup = (CustomObjectPrivilegeGroup)privilegeGroup;
                        Map customObjectsByPrivilege = this.customObjectPrivilegeGroupMap.computeIfAbsent(privilegeApplicationKey, app -> new HashMap()).computeIfAbsent(customObjectPrivilegeGroup, c -> new HashMap());
                        for (Privilege privilege : privileges) {
                            customObjectsByPrivilege.computeIfAbsent(privilege, p -> new HashSet()).addAll(privilegeObjects);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ApplicationPrivilegeProvider getApplicationPrivilegeProvider(PrivilegeApplicationKey privilegeApplicationKey) {
        UserApplicationPrivilege userApplicationPrivilege = this.userApplicationPrivilegeByApplication.get(privilegeApplicationKey);
        if (userApplicationPrivilege == null) {
            if (this.user.getUserAccountStatus() == UserAccountStatus.SUPER_ADMIN) {
                return new AllowAllPrivilegeProvider();
            }
            userApplicationPrivilege = new UserApplicationPrivilege(this, privilegeApplicationKey);
            this.userApplicationPrivilegeByApplication.put(privilegeApplicationKey, userApplicationPrivilege);
        }
        return userApplicationPrivilege;
    }

    public Map<PrivilegeApplicationKey, Set<SimplePrivilege>> getSimplePrivilegesMap() {
        return this.simplePrivilegesMap;
    }

    public Map<PrivilegeApplicationKey, Map<SimpleOrganizationalPrivilege, Set<OrganizationUnitView>>> getSimpleOrganizationPrivilegeMap() {
        return this.simpleOrganizationPrivilegeMap;
    }

    public Map<PrivilegeApplicationKey, Map<SimpleCustomObjectPrivilege, Set<PrivilegeObject>>> getSimpleCustomObjectPrivilegeMap() {
        return this.simpleCustomObjectPrivilegeMap;
    }

    public Map<PrivilegeApplicationKey, Map<StandardPrivilegeGroup, Set<Privilege>>> getStandardPrivilegeMap() {
        return this.standardPrivilegeMap;
    }

    public Map<PrivilegeApplicationKey, Map<OrganizationalPrivilegeGroup, Map<Privilege, Set<OrganizationUnitView>>>> getOrganizationPrivilegeGroupMap() {
        return this.organizationPrivilegeGroupMap;
    }

    public Map<PrivilegeApplicationKey, Map<CustomObjectPrivilegeGroup, Map<Privilege, Set<PrivilegeObject>>>> getCustomObjectPrivilegeGroupMap() {
        return this.customObjectPrivilegeGroupMap;
    }
}

