/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.system.template;

import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiTemplateReference;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.FontStyle;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Line;
import org.teamapps.ux.component.format.LineType;
import org.teamapps.ux.component.format.SizeType;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.gridtemplate.AbstractTemplateElement;
import org.teamapps.ux.component.template.gridtemplate.FloatingElement;
import org.teamapps.ux.component.template.gridtemplate.GridTemplate;
import org.teamapps.ux.component.template.gridtemplate.IconElement;
import org.teamapps.ux.component.template.gridtemplate.ImageElement;
import org.teamapps.ux.component.template.gridtemplate.TextElement;
import org.teamapps.ux.component.template.htmltemplate.MustacheTemplate;

public enum Templates implements Template
{
    LOGIN_TEMPLATE((Template)Templates.createLoginTemplate()),
    LIST_4_LINES_TEMPLATE(Templates.create4LinesTemplate()),
    NODE_TEMPLATE((Template)Templates.createNodeTemplate()),
    ORGANIZATION_GRAPH_TEMPLATE(Templates.createOrganizationGraphTreeNodeTpl()),
    ORGANIZATION_GRAPH_SMALL_TEMPLATE(Templates.createOrganizationGraphTreeNodeSmallTpl());

    public static final String PROPERTY_IMAGE = "image";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_BADGE = "badge";
    public static final String PROPERTY_CAPTION = "caption";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_LINE3 = "line3";
    public static final String PROPERTY_LINE4 = "line4";
    public static final String PROPERTY_LINE1_LEFT_ICON = "lin1LeftIcon";
    public static final String PROPERTY_BORDER_COLOR = "borderColor";
    private final Template template;
    private final UiTemplateReference uiTemplateReference;

    public static MustacheTemplate createNodeTemplate() {
        String tpl = "<div style=\"background-image: url({{image}}); top:-17px; left:-60px; position: absolute;width: 80px; height: 80px;background-size: cover; background-position: center center; margin-bottom: 4px; border-radius: 50%; border: 2px solid {{borderColor}}; \"></div>\n<div style='width:100%;height:100%; padding-left: 24px; padding-top: 5px; overflow: hidden;'>\n<div style=\"white-space: nowrap;\">{{caption}}</div>\n<div style=\"white-space: nowrap;\">{{description}}</div>\n<div style=\"white-space: nowrap;\">{{line3}}</div>\n<div style=\"white-space: nowrap; width: fit-content; border-radius: 1000px; color:rgba(66,66,66,1);background-color:rgba(238,238,238,1);font-size:60%; padding: 1px 5px;\">{{badge}}</div>\n</div>";
        return new MustacheTemplate(tpl);
    }

    public static MustacheTemplate createLoginTemplate() {
        String tpl = "<div class=\"token-login-entry\">\n    <style>\n        .token-login-entry {\n            background: transparent !important;\n            border: none !important;\n            box-shadow: none !important;\n            font-family: \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n            display: flex;\n            flex-direction: column;\n            align-items: center;\n            transform: scale(1);\n        }\n        .token-login-entry:hover {\n            transform: scale(1.2);\n        }\n        .token-login-entry, .token-login-entry:hover {\n            transition: transform .3s !important;\n        }\n        .token-login-entry > .img {\n            width: 100px;\n            height: 100px;\n            background-size: cover;\n            background-position: center center;\n            margin-bottom: 6px;\n            border-radius: 50%;\n            border: 1px solid #fff;\n            box-shadow: 0 3px 10px 0 #000000a1;\n        }\n        .token-login-entry > .line1,\n        .token-login-entry > .line2 {\n            text-align: center;\n            font-size: 105%;\n            text-overflow: ellipsis;\n            overflow: hidden;\n        }\n    </style>\n    <div class=\"img\" style=\"background-image: url('{{image}}');\"></div>\n    <div class=\"line1\">{{caption}}</div>\n    <div class=\"line2\">{{#description}}{{description}}{{/description}}{{^description}}&nbsp;{{/description}}</div>\n</div>";
        return new MustacheTemplate(tpl);
    }

    public static Template createOrganizationGraphTreeNodeTpl() {
        GridTemplate tpl = new GridTemplate().setPadding(new Spacing(5, 1, 1, 40)).addColumn(SizingPolicy.fixed((float)240.0f)).addRow(SizeType.FIXED, 18.0f, 18, 0, 0).addRow(SizeType.FIXED, 16.0f, 16, 0, 0).addRow(SizeType.FIXED, 16.0f, 16, 0, 0).addElement(new TextElement(PROPERTY_CAPTION, 0, 0).setWrapLines(false).setFontStyle(new FontStyle(1.2f, (Color)Color.MATERIAL_BLUE_900, null, false, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement(PROPERTY_DESCRIPTION, 1, 0).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREY_900, null, true, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement(PROPERTY_LINE3, 2, 0).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREY_700, null, false, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT));
        return tpl;
    }

    public static Template createOrganizationGraphTreeNodeSmallTpl() {
        GridTemplate tpl = new GridTemplate().setPadding(new Spacing(2, 1, 1, 30)).addColumn(SizingPolicy.fixed((float)200.0f)).addRow(SizeType.FIXED, 16.0f, 16, 0, 0).addRow(SizeType.FIXED, 16.0f, 16, 0, 0).addElement(new TextElement(PROPERTY_DESCRIPTION, 0, 0).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREEN_900, null, true, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement(PROPERTY_LINE3, 1, 0).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREY_700, null, false, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT));
        return tpl;
    }

    public static Template create4LinesTemplate() {
        GridTemplate tpl = new GridTemplate().setPadding(new Spacing(1)).setGridGap(0).addColumn(SizingPolicy.AUTO).addColumn(SizingPolicy.FRACTION).addRow(SizeType.FIXED, 18.0f, 18, 0, 0).addRow(SizeType.FIXED, 18.0f, 18, 0, 0).addRow(SizeType.FIXED, 18.0f, 18, 0, 0).addRow(SizeType.FIXED, 18.0f, 18, 0, 0).addElement(new ImageElement(PROPERTY_IMAGE, 0, 0, 68, 68).setRowSpan(4).setBorder(new Border(new Line((Color)Color.GRAY, LineType.SOLID, 0.5f)).setBorderRadius(300.0f)).setVerticalAlignment(VerticalElementAlignment.CENTER).setMargin(new Spacing(0, 8, 0, 4))).addElement(((IconElement)new IconElement(PROPERTY_ICON, 0, 0, 64).setRowSpan(4)).setVerticalAlignment(VerticalElementAlignment.CENTER).setMargin(new Spacing(0, 8, 0, 4))).addElement(new FloatingElement(0, 1).addElement(new IconElement(PROPERTY_LINE1_LEFT_ICON, 0, 0, 16).setMargin(new Spacing(0, 4, 0, 0))).addElement((AbstractTemplateElement)new TextElement(PROPERTY_CAPTION, 0, 0).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREY_900, null, true, false, false))).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement(PROPERTY_DESCRIPTION, 1, 1).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREY_700, null, false, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement(PROPERTY_LINE3, 2, 1).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_GREY_700, null, false, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement(PROPERTY_LINE4, 3, 1).setWrapLines(false).setFontStyle(new FontStyle(1.0f, (Color)Color.MATERIAL_BLUE_900, null, true, false, false)).setVerticalAlignment(VerticalElementAlignment.CENTER).setHorizontalAlignment(HorizontalElementAlignment.LEFT));
        tpl.setBorder(new Border(new Line((Color)Color.MATERIAL_GREY_300, LineType.SOLID, 0.5f), null, null, null));
        return tpl;
    }

    private Templates(Template template) {
        this.template = template;
        this.uiTemplateReference = new UiTemplateReference(this.name());
    }

    public UiTemplate createUiTemplate() {
        return this.uiTemplateReference;
    }

    public List<String> getPropertyNames() {
        return this.template.getPropertyNames();
    }

    public Template getTemplate() {
        return this.template;
    }
}

