/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationFolder;
import org.teamapps.model.controlcenter.ApplicationFolderType;
import org.teamapps.model.controlcenter.Message;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbApplicationFolder
extends AbstractUdbEntity<ApplicationFolder>
implements ApplicationFolder {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static IntegerIndex metaRestoreDate;
    protected static IntegerIndex metaRestoredBy;
    protected static TextIndex name;
    protected static SingleReferenceIndex application;
    protected static ShortIndex applicationFolderType;
    protected static SingleReferenceIndex parent;
    protected static MultiReferenceIndex children;
    protected static MultiReferenceIndex messages;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        metaRestoreDate = (IntegerIndex)tableIndex.getColumnIndex("metaRestoreDate");
        metaRestoredBy = (IntegerIndex)tableIndex.getColumnIndex("metaRestoredBy");
        name = (TextIndex)tableIndex.getColumnIndex("name");
        application = (SingleReferenceIndex)tableIndex.getColumnIndex("application");
        applicationFolderType = (ShortIndex)tableIndex.getColumnIndex("applicationFolderType");
        parent = (SingleReferenceIndex)tableIndex.getColumnIndex("parent");
        children = (MultiReferenceIndex)tableIndex.getColumnIndex("children");
        messages = (MultiReferenceIndex)tableIndex.getColumnIndex("messages");
    }

    public static List<ApplicationFolder> getAll() {
        return new EntityBitSetList(ApplicationFolder.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationFolder> getDeletedRecords() {
        return new EntityBitSetList(ApplicationFolder.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ApplicationFolder> sort(List<ApplicationFolder> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbApplicationFolder.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<ApplicationFolder> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbApplicationFolder.sort((TableIndex)table, ApplicationFolder.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationFolder() {
        super(table);
    }

    public UdbApplicationFolder(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public ApplicationFolder build() {
        return new UdbApplicationFolder();
    }

    public ApplicationFolder build(int id) {
        return new UdbApplicationFolder(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public ApplicationFolder setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public ApplicationFolder setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public ApplicationFolder setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public ApplicationFolder setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public ApplicationFolder setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public ApplicationFolder setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public ApplicationFolder setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public ApplicationFolder setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public ApplicationFolder setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public ApplicationFolder setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public ApplicationFolder setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public ApplicationFolder setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Instant getMetaRestoreDate() {
        return this.getTimestampValue(metaRestoreDate);
    }

    @Override
    public ApplicationFolder setMetaRestoreDate(Instant value) {
        this.setTimestampValue(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoreDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaRestoreDate);
    }

    @Override
    public ApplicationFolder setMetaRestoreDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaRestoreDate);
        return this;
    }

    @Override
    public long getMetaRestoreDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaRestoreDate);
    }

    @Override
    public ApplicationFolder setMetaRestoreDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoredBy() {
        return this.getIntValue(metaRestoredBy);
    }

    @Override
    public ApplicationFolder setMetaRestoredBy(int value) {
        this.setIntValue(value, metaRestoredBy);
        return this;
    }

    @Override
    public String getName() {
        return this.getTextValue(name);
    }

    @Override
    public ApplicationFolder setName(String value) {
        this.setTextValue(value, name);
        return this;
    }

    @Override
    public Application getApplication() {
        if (this.isChanged((ColumnIndex)application)) {
            return (Application)this.getReferenceChangeValue((ColumnIndex)application);
        }
        int id = application.getValue(this.getId());
        if (id > 0) {
            return Application.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationFolder setApplication(Application value) {
        this.setSingleReferenceValue(application, value, table);
        return this;
    }

    @Override
    public ApplicationFolderType getApplicationFolderType() {
        return (ApplicationFolderType)this.getEnumValue(applicationFolderType, ApplicationFolderType.values());
    }

    @Override
    public ApplicationFolder setApplicationFolderType(ApplicationFolderType value) {
        this.setEnumValue(applicationFolderType, value);
        return this;
    }

    @Override
    public ApplicationFolder getParent() {
        if (this.isChanged((ColumnIndex)parent)) {
            return (ApplicationFolder)this.getReferenceChangeValue((ColumnIndex)parent);
        }
        int id = parent.getValue(this.getId());
        if (id > 0) {
            return ApplicationFolder.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationFolder setParent(ApplicationFolder value) {
        this.setSingleReferenceValue(parent, value, table);
        return this;
    }

    @Override
    public List<ApplicationFolder> getChildren() {
        return this.getMultiReferenceValue(children, ApplicationFolder.getBuilder());
    }

    @Override
    public ApplicationFolder setChildren(List<ApplicationFolder> value) {
        this.setMultiReferenceValue(value, children);
        return this;
    }

    @Override
    public int getChildrenCount() {
        return this.getMultiReferenceValueCount(children, ApplicationFolder.getBuilder());
    }

    @Override
    public ApplicationFolder setChildren(ApplicationFolder ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), children);
        return this;
    }

    @Override
    public BitSet getChildrenAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(children, ApplicationFolder.getBuilder());
    }

    @Override
    public ApplicationFolder addChildren(List<ApplicationFolder> value) {
        this.addMultiReferenceValue(value, children);
        return this;
    }

    @Override
    public ApplicationFolder addChildren(ApplicationFolder ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), children);
        return this;
    }

    @Override
    public ApplicationFolder removeChildren(List<ApplicationFolder> value) {
        this.removeMultiReferenceValue(value, children);
        return this;
    }

    @Override
    public ApplicationFolder removeChildren(ApplicationFolder ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), children);
        return this;
    }

    @Override
    public ApplicationFolder removeAllChildren() {
        this.removeAllMultiReferenceValue(children);
        return this;
    }

    @Override
    public List<Message> getMessages() {
        return this.getMultiReferenceValue(messages, Message.getBuilder());
    }

    @Override
    public ApplicationFolder setMessages(List<Message> value) {
        this.setMultiReferenceValue(value, messages);
        return this;
    }

    @Override
    public int getMessagesCount() {
        return this.getMultiReferenceValueCount(messages, Message.getBuilder());
    }

    @Override
    public ApplicationFolder setMessages(Message ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), messages);
        return this;
    }

    @Override
    public BitSet getMessagesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(messages, Message.getBuilder());
    }

    @Override
    public ApplicationFolder addMessages(List<Message> value) {
        this.addMultiReferenceValue(value, messages);
        return this;
    }

    @Override
    public ApplicationFolder addMessages(Message ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), messages);
        return this;
    }

    @Override
    public ApplicationFolder removeMessages(List<Message> value) {
        this.removeMultiReferenceValue(value, messages);
        return this;
    }

    @Override
    public ApplicationFolder removeMessages(Message ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), messages);
        return this;
    }

    @Override
    public ApplicationFolder removeAllMessages() {
        this.removeAllMultiReferenceValue(messages);
        return this;
    }

    public UdbApplicationFolder save(Transaction transaction, boolean strictChangeVerification) {
        this.saveRecord(transaction, strictChangeVerification);
        return this;
    }

    public UdbApplicationFolder saveTransactional(boolean strictChangeVerification) {
        this.saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    public UdbApplicationFolder save() {
        this.saveRecord();
        return this;
    }

    public void delete(Transaction transaction) {
        this.deleteRecord(transaction);
    }

    public void delete() {
        this.deleteRecord();
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord();
    }
}

