/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;
import org.teamapps.universaldb.transaction.Transaction;

public class UdbApplicationPerspective
extends AbstractUdbEntity<ApplicationPerspective>
implements ApplicationPerspective {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static IntegerIndex metaRestoreDate;
    protected static IntegerIndex metaRestoredBy;
    protected static SingleReferenceIndex application;
    protected static TextIndex name;
    protected static TextIndex icon;
    protected static TextIndex titleKey;
    protected static TextIndex descriptionKey;
    protected static BooleanIndex autoProvision;
    protected static BooleanIndex toolbarPerspectiveMenu;
    protected static MultiReferenceIndex managedPerspectives;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        metaRestoreDate = (IntegerIndex)tableIndex.getColumnIndex("metaRestoreDate");
        metaRestoredBy = (IntegerIndex)tableIndex.getColumnIndex("metaRestoredBy");
        application = (SingleReferenceIndex)tableIndex.getColumnIndex("application");
        name = (TextIndex)tableIndex.getColumnIndex("name");
        icon = (TextIndex)tableIndex.getColumnIndex("icon");
        titleKey = (TextIndex)tableIndex.getColumnIndex("titleKey");
        descriptionKey = (TextIndex)tableIndex.getColumnIndex("descriptionKey");
        autoProvision = (BooleanIndex)tableIndex.getColumnIndex("autoProvision");
        toolbarPerspectiveMenu = (BooleanIndex)tableIndex.getColumnIndex("toolbarPerspectiveMenu");
        managedPerspectives = (MultiReferenceIndex)tableIndex.getColumnIndex("managedPerspectives");
    }

    public static List<ApplicationPerspective> getAll() {
        return new EntityBitSetList(ApplicationPerspective.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationPerspective> getDeletedRecords() {
        return new EntityBitSetList(ApplicationPerspective.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ApplicationPerspective> sort(List<ApplicationPerspective> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbApplicationPerspective.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<ApplicationPerspective> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbApplicationPerspective.sort((TableIndex)table, ApplicationPerspective.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationPerspective() {
        super(table);
    }

    public UdbApplicationPerspective(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public ApplicationPerspective build() {
        return new UdbApplicationPerspective();
    }

    public ApplicationPerspective build(int id) {
        return new UdbApplicationPerspective(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public ApplicationPerspective setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public ApplicationPerspective setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public ApplicationPerspective setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public ApplicationPerspective setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public ApplicationPerspective setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public ApplicationPerspective setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public ApplicationPerspective setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public ApplicationPerspective setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public ApplicationPerspective setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public ApplicationPerspective setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public ApplicationPerspective setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public ApplicationPerspective setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Instant getMetaRestoreDate() {
        return this.getTimestampValue(metaRestoreDate);
    }

    @Override
    public ApplicationPerspective setMetaRestoreDate(Instant value) {
        this.setTimestampValue(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoreDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaRestoreDate);
    }

    @Override
    public ApplicationPerspective setMetaRestoreDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaRestoreDate);
        return this;
    }

    @Override
    public long getMetaRestoreDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaRestoreDate);
    }

    @Override
    public ApplicationPerspective setMetaRestoreDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoredBy() {
        return this.getIntValue(metaRestoredBy);
    }

    @Override
    public ApplicationPerspective setMetaRestoredBy(int value) {
        this.setIntValue(value, metaRestoredBy);
        return this;
    }

    @Override
    public Application getApplication() {
        if (this.isChanged((ColumnIndex)application)) {
            return (Application)this.getReferenceChangeValue((ColumnIndex)application);
        }
        int id = application.getValue(this.getId());
        if (id > 0) {
            return Application.getById(id);
        }
        return null;
    }

    @Override
    public ApplicationPerspective setApplication(Application value) {
        this.setSingleReferenceValue(application, value, table);
        return this;
    }

    @Override
    public String getName() {
        return this.getTextValue(name);
    }

    @Override
    public ApplicationPerspective setName(String value) {
        this.setTextValue(value, name);
        return this;
    }

    @Override
    public String getIcon() {
        return this.getTextValue(icon);
    }

    @Override
    public ApplicationPerspective setIcon(String value) {
        this.setTextValue(value, icon);
        return this;
    }

    @Override
    public String getTitleKey() {
        return this.getTextValue(titleKey);
    }

    @Override
    public ApplicationPerspective setTitleKey(String value) {
        this.setTextValue(value, titleKey);
        return this;
    }

    @Override
    public String getDescriptionKey() {
        return this.getTextValue(descriptionKey);
    }

    @Override
    public ApplicationPerspective setDescriptionKey(String value) {
        this.setTextValue(value, descriptionKey);
        return this;
    }

    @Override
    public boolean getAutoProvision() {
        return this.getBooleanValue(autoProvision);
    }

    @Override
    public ApplicationPerspective setAutoProvision(boolean value) {
        this.setBooleanValue(value, autoProvision);
        return this;
    }

    @Override
    public boolean isAutoProvision() {
        return this.getBooleanValue(autoProvision);
    }

    @Override
    public boolean getToolbarPerspectiveMenu() {
        return this.getBooleanValue(toolbarPerspectiveMenu);
    }

    @Override
    public ApplicationPerspective setToolbarPerspectiveMenu(boolean value) {
        this.setBooleanValue(value, toolbarPerspectiveMenu);
        return this;
    }

    @Override
    public boolean isToolbarPerspectiveMenu() {
        return this.getBooleanValue(toolbarPerspectiveMenu);
    }

    @Override
    public List<ManagedApplicationPerspective> getManagedPerspectives() {
        return this.getMultiReferenceValue(managedPerspectives, ManagedApplicationPerspective.getBuilder());
    }

    @Override
    public ApplicationPerspective setManagedPerspectives(List<ManagedApplicationPerspective> value) {
        this.setMultiReferenceValue(value, managedPerspectives);
        return this;
    }

    @Override
    public int getManagedPerspectivesCount() {
        return this.getMultiReferenceValueCount(managedPerspectives, ManagedApplicationPerspective.getBuilder());
    }

    @Override
    public ApplicationPerspective setManagedPerspectives(ManagedApplicationPerspective ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), managedPerspectives);
        return this;
    }

    @Override
    public BitSet getManagedPerspectivesAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(managedPerspectives, ManagedApplicationPerspective.getBuilder());
    }

    @Override
    public ApplicationPerspective addManagedPerspectives(List<ManagedApplicationPerspective> value) {
        this.addMultiReferenceValue(value, managedPerspectives);
        return this;
    }

    @Override
    public ApplicationPerspective addManagedPerspectives(ManagedApplicationPerspective ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), managedPerspectives);
        return this;
    }

    @Override
    public ApplicationPerspective removeManagedPerspectives(List<ManagedApplicationPerspective> value) {
        this.removeMultiReferenceValue(value, managedPerspectives);
        return this;
    }

    @Override
    public ApplicationPerspective removeManagedPerspectives(ManagedApplicationPerspective ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), managedPerspectives);
        return this;
    }

    @Override
    public ApplicationPerspective removeAllManagedPerspectives() {
        this.removeAllMultiReferenceValue(managedPerspectives);
        return this;
    }

    public UdbApplicationPerspective save(Transaction transaction, boolean strictChangeVerification) {
        this.saveRecord(transaction, strictChangeVerification);
        return this;
    }

    public UdbApplicationPerspective saveTransactional(boolean strictChangeVerification) {
        this.saveRecord(UniversalDB.getThreadLocalTransaction(), strictChangeVerification);
        return this;
    }

    public UdbApplicationPerspective save() {
        this.saveRecord();
        return this;
    }

    public void delete(Transaction transaction) {
        this.deleteRecord(transaction);
    }

    public void delete() {
        this.deleteRecord();
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord();
    }
}

