import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiCalendar_DataNeededEvent, UiCalendar_DayClickedEvent, UiCalendar_DayHeaderClickedEvent, UiCalendar_EventClickedEvent, UiCalendar_EventMovedEvent, UiCalendar_IntervalSelectedEvent, UiCalendar_MonthHeaderClickedEvent, UiCalendar_ViewChangedEvent, UiCalendar_WeekHeaderClickedEvent, UiCalendarCommandHandler, UiCalendarConfig, UiCalendarEventSource } from "../generated/UiCalendarConfig";
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiCalendarViewMode } from "../generated/UiCalendarViewMode";
import { UiCalendarEventClientRecordConfig } from "../generated/UiCalendarEventClientRecordConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { Calendar } from '@fullcalendar/core';
import { EventInput } from "@fullcalendar/core/structs/event";
import { EventSourceError, ExtendedEventSourceInput } from "@fullcalendar/core/structs/event-source";
export declare class UiCalendar extends AbstractUiComponent<UiCalendarConfig> implements UiCalendarCommandHandler, UiCalendarEventSource {
    readonly onEventClicked: TeamAppsEvent<UiCalendar_EventClickedEvent>;
    readonly onEventMoved: TeamAppsEvent<UiCalendar_EventMovedEvent>;
    readonly onDayClicked: TeamAppsEvent<UiCalendar_DayClickedEvent>;
    readonly onIntervalSelected: TeamAppsEvent<UiCalendar_IntervalSelectedEvent>;
    readonly onViewChanged: TeamAppsEvent<UiCalendar_ViewChangedEvent>;
    readonly onDataNeeded: TeamAppsEvent<UiCalendar_DataNeededEvent>;
    readonly onDayHeaderClicked: TeamAppsEvent<UiCalendar_DayHeaderClickedEvent>;
    readonly onWeekHeaderClicked: TeamAppsEvent<UiCalendar_WeekHeaderClickedEvent>;
    readonly onMonthHeaderClicked: TeamAppsEvent<UiCalendar_MonthHeaderClickedEvent>;
    private $main;
    private eventSource;
    private templateRenderers;
    private calendar;
    constructor(config: UiCalendarConfig, context: TeamAppsUiContext);
    registerTemplate(id: string, template: UiTemplateConfig): void;
    setViewMode(viewMode: UiCalendarViewMode): void;
    setDisplayedDate(date: number): void;
    addEvent(theEvent: any): void;
    removeEvent(eventId: any): void;
    setCalendarData(events: UiCalendarEventClientRecordConfig[]): void;
    clearCalendar(): void;
    private refreshEventsDisplay;
    onResize(): void;
    doGetMainElement(): HTMLElement;
    destroy(): void;
    convertToFullCalendarEvent(event: UiCalendarEventClientRecordConfig): EventInput;
    setTimeZoneId(timeZoneId: string): void;
}
export declare class UiCalendarFullCalendarEventSource implements ExtendedEventSourceInput {
    private teamappsUiContext;
    private componentId;
    private fullCalendarAccessor;
    readonly onViewChanged: TeamAppsEvent<UiCalendar_ViewChangedEvent>;
    readonly onDataNeeded: TeamAppsEvent<UiCalendar_DataNeededEvent>;
    private logger;
    private intervalManager;
    private cachedEvents;
    private queriesDisabled;
    constructor(teamappsUiContext: TeamAppsUiContext, componentId: string, fullCalendarAccessor: () => Calendar);
    events(query: {
        start: Date;
        end: Date;
        timeZone: string;
    }, successCallback: (events: EventInput[]) => void, failureCallback: (error: EventSourceError) => void): void;
    addEvents(start: number, end: number, newEvents: EventInput[]): void;
    addEvent(newEvent: EventInput): void;
    removeEvent(eventId: number | string): void;
    getEvent(eventId: number | string): any;
    removeAllEvents(): void;
    setQueriesDisabled(queriesDisabled: boolean): void;
}
