import { AbstractUiGraph } from "./AbstractUiGraph";
import { ScaleTime } from 'd3';
import { UiGraphGroupConfig } from "../../generated/UiGraphGroupConfig";
import { UiGraphGroupDataConfig } from "../../generated/UiGraphGroupDataConfig";
import { GraphContext } from "./GraphContext";
export declare class UiGraphGroup extends AbstractUiGraph<UiGraphGroupConfig, UiGraphGroupDataConfig> {
    private dropShadowFilterId;
    private $yZeroLine;
    private graphs;
    constructor(timeGraphId: string, config: UiGraphGroupConfig, dropShadowFilterId: string, graphContext: GraphContext);
    getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    addData(zoomLevel: number, data: UiGraphGroupDataConfig): void;
    getYDataBounds(xInterval: [number, number]): [number, number];
    resetData(): void;
    updateZoomX(zoomLevelIndex: number, scaleX: ScaleTime<number, number>): void;
    private initDomNodes;
    protected doRedraw(): void;
    setYRange(range: [number, number]): void;
}
