import { AbstractUiGraph } from "./AbstractUiGraph";
import { UiLineGraphDataConfig } from "../../generated/UiLineGraphDataConfig";
import { UiLineGraphConfig } from "../../generated/UiLineGraphConfig";
export declare class UiLineGraph extends AbstractUiGraph<UiLineGraphConfig, UiLineGraphDataConfig> {
    private dropShadowFilterId;
    private line;
    private $line;
    private area;
    private $area;
    private $dots;
    private $defs;
    private colorScale;
    private $yZeroLine;
    private dataStore;
    constructor(timeGraphId: string, config: UiLineGraphConfig, dropShadowFilterId: string);
    getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    addData(zoomLevel: number, data: UiLineGraphDataConfig): void;
    resetData(): void;
    getYDataBounds(xInterval: [number, number]): [number, number];
    private initDomNodes;
    doRedraw(): void;
    setConfig(graphConfig: UiLineGraphConfig): void;
    private initLinesAndColorScale;
}
