import { UiTagComboBoxCommandHandler, UiTagComboBoxConfig, UiTagComboBoxEventSource } from "../../generated/UiTagComboBoxConfig";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiField } from "./UiField";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
import { UiComboBoxTreeRecordConfig } from "../../generated/UiComboBoxTreeRecordConfig";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
export declare class UiTagComboBox extends UiField<UiTagComboBoxConfig, UiComboBoxTreeRecordConfig[]> implements UiTagComboBoxEventSource, UiTagComboBoxCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private $originalInput;
    private trivialTagComboBox;
    private templateRenderers;
    private resultCallbacksQueue;
    private freeTextIdEntryCounter;
    protected initialize(config: UiTagComboBoxConfig, context: TeamAppsUiContext): void;
    protected initFocusHandling(): void;
    private renderRecord;
    isValidData(v: any[]): boolean;
    getMainInnerDomElement(): HTMLElement;
    protected displayCommittedValue(): void;
    getTransientValue(): any[];
    protected convertValueForSendingToServer(values: UiComboBoxTreeRecordConfig[]): any;
    focus(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    replaceFreeTextEntry(freeText: string, record: UiComboBoxTreeRecordConfig): void;
    destroy(): void;
    getReadOnlyHtml(records: UiComboBoxTreeRecordConfig[], availableWidth: number): string;
    getDefaultValue(): any[];
    valuesChanged(v1: UiComboBoxTreeRecordConfig[], v2: UiComboBoxTreeRecordConfig[]): boolean;
}
