import { LocalDateTime } from "../../datetime/LocalDateTime";
export interface DateSuggestion {
    date: LocalDateTime;
    ymdOrder: string;
}
export declare type YearMonthDayOrder = "YMD" | "YDM" | "MDY" | "MYD" | "DMY" | "DYM";
export interface Options {
    locale?: string;
    preferredYearMonthDayOrder?: YearMonthDayOrder;
    /**
     * By default, the engine favors future dates. This flag makes it favor past dates.
     */
    favorPastDates?: boolean;
}
export declare class DateSuggestionEngine {
    private preferredYmdOrder;
    private favorPastDates;
    constructor(options: Options);
    generateSuggestions(searchString: string, now: LocalDateTime, options?: {
        suggestAdjacentWeekForEmptyInput?: boolean;
        shuffledFormatSuggestionsEnabled?: boolean;
    }): LocalDateTime[];
    private removeDuplicateDates;
    generateSuggestionsForDigitsOnlyInput(input: string, today: LocalDateTime): DateSuggestion[];
    private validateFragments;
    todayOrFavoriteDirection(date: LocalDateTime, today: LocalDateTime): boolean;
    private createSuggestionsForFragments;
    private createAdjacentWeekDaySuggestions;
    private findNextValidDate;
}
export declare function getYearMonthDayOrderFromDateFormat(dateFormat: string): YearMonthDayOrder;
export declare function getYearMonthDayOrderForLocale(locale: string): YearMonthDayOrder;
