/// <reference types="slickgrid" />
import { UiTableClientRecordConfig } from "../../generated/UiTableClientRecordConfig";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
import { UiIdentifiableClientRecordConfig } from "../../generated/UiIdentifiableClientRecordConfig";
import DataProvider = Slick.DataProvider;
export declare class TableDataProvider implements DataProvider<UiTableClientRecordConfig> {
    onDataLoading: Slick.Event<unknown>;
    private dataStartIndex;
    private data;
    private recordById;
    private totalNumberOfRecords;
    getLength(): number;
    getItem(index: number): UiTableClientRecordConfig;
    getItemMetadata(index: number): Slick.RowMetadata<any>;
    updateData(startIndex: number, recordIds: number[], newRecords: UiIdentifiableClientRecordConfig[], totalNumberOfRecords: number): number[] | true;
    private calculateChangingRowNumbers;
    clear(): void;
    getRecordById(recordId: number): UiTableClientRecordConfig;
    getRowIndexByRecordId(recordId: number): number;
    setCellMessages(recordId: number, columnName: string, messages: UiFieldMessageConfig[]): void;
    clearAllCellMessages(): void;
    setCellMarked(recordId: any, columnName: string, marked: boolean): void;
    clearAllCellMarkings(): void;
    getSelectedRowsIndexes(): number[];
    setSelectedRows(rows: number[]): void;
    /**
     *  Selection management might seem a bit tricky, but with the following explanation, things might clear up:
     *  - When the user selects a row, it gets selected on the client side (dataprovider) and server side.
     *  - Even after getting thrown out of the data provider, the server still knows about the selection and will set the selected flag
     *    when re-sending a selected record to the client
     *  - When a record is selected via server-side API, it also gets selected here (if present).
     *  TODO multi selection handling does currently not work with rows outside the buffer!
     */
    agreesWithSelectedRows(rowIndexes: number[]): boolean;
}
