import { TeamAppsUiContextInternalApi } from "./TeamAppsUiContext";
import { UiConfigurationConfig } from "../generated/UiConfigurationConfig";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiEvent } from "../generated/UiEvent";
import { UiCommand } from '../generated/UiCommand';
import { TemplateRegistry } from "./TemplateRegistry";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiClientObject } from "./UiClientObject";
import { UiClientObjectConfig } from "../generated/UiClientObjectConfig";
import { UiWindow } from "./UiWindow";
import { UiQuery } from "../generated/UiQuery";
export declare class DefaultTeamAppsUiContext implements TeamAppsUiContextInternalApi {
    private static logger;
    readonly onStaticMethodCommandInvocation: TeamAppsEvent<UiCommand>;
    readonly sessionId: string;
    isHighDensityScreen: boolean;
    config: UiConfigurationConfig;
    readonly templateRegistry: TemplateRegistry;
    private components;
    private _executingCommand;
    private connection;
    private commandExecutor;
    private expiredMessageWindow;
    private errorMessageWindow;
    private terminatedMessageWindow;
    private componentEventSubscriptionManager;
    constructor(webSocketUrl: string, clientParameters?: {
        [key: string]: string | number;
    });
    get executingCommand(): boolean;
    sendEvent(eventObject: UiEvent): void;
    sendQuery(query: UiQuery): Promise<any>;
    registerClientObject(clientObject: UiClientObject, id: string, teamappsType: string): void;
    createClientObject(config: UiClientObjectConfig): UiClientObject;
    refreshComponent(config: UiComponentConfig): void;
    destroyClientObject(id: string): void;
    getClientObjectById(id: string): UiClientObject;
    private replaceComponentReferencesWithInstances;
    private executeCommand;
    setSessionMessageWindows(expiredMessageWindow: UiWindow, errorMessageWindow: UiWindow, terminatedMessageWindow: UiWindow): void;
}
