import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiTable_CellClickedEvent, UiTable_CellEditingStartedEvent, UiTable_CellEditingStoppedEvent, UiTable_CellValueChangedEvent, UiTable_ColumnSizeChangeEvent, UiTable_ContextMenuRequestedEvent, UiTable_DisplayedRangeChangedEvent, UiTable_FieldOrderChangeEvent, UiTable_RowsSelectedEvent, UiTable_SortingChangedEvent, UiTableCommandHandler, UiTableConfig, UiTableEventSource } from "../../generated/UiTableConfig";
import { UiTableColumnConfig } from "../../generated/UiTableColumnConfig";
import { AbstractUiComponent } from "../AbstractUiComponent";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiSortDirection } from "../../generated/UiSortDirection";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
import { UiTableClientRecordConfig } from "../../generated/UiTableClientRecordConfig";
import { UiComponent } from "../UiComponent";
import { UiRefreshableTableConfigUpdateConfig } from "../../generated/UiRefreshableTableConfigUpdateConfig";
export declare class UiTable extends AbstractUiComponent<UiTableConfig> implements UiTableCommandHandler, UiTableEventSource {
    readonly onCellEditingStarted: TeamAppsEvent<UiTable_CellEditingStartedEvent>;
    readonly onCellEditingStopped: TeamAppsEvent<UiTable_CellEditingStoppedEvent>;
    readonly onCellValueChanged: TeamAppsEvent<UiTable_CellValueChangedEvent>;
    readonly onCellClicked: TeamAppsEvent<UiTable_CellClickedEvent>;
    readonly onSortingChanged: TeamAppsEvent<UiTable_SortingChangedEvent>;
    readonly onRowsSelected: TeamAppsEvent<UiTable_RowsSelectedEvent>;
    readonly onFieldOrderChange: TeamAppsEvent<UiTable_FieldOrderChangeEvent>;
    readonly onColumnSizeChange: TeamAppsEvent<UiTable_ColumnSizeChangeEvent>;
    readonly onDisplayedRangeChanged: TeamAppsEvent<UiTable_DisplayedRangeChangedEvent>;
    readonly onContextMenuRequested: TeamAppsEvent<UiTable_ContextMenuRequestedEvent>;
    private $component;
    private _grid;
    private allColumns;
    private dataProvider;
    private _$loadingIndicator;
    private loadingIndicatorFadeInTimer;
    private _sortField;
    private _sortDirection;
    private doNotFireEventBecauseSelectionIsCausedByApiCall;
    private dropDown;
    private $selectionFrame;
    private headerRowFields;
    private footerRowFields;
    private $editorFieldTempContainer;
    private contextMenu;
    private rowSelectionCausedByApiCall;
    constructor(config: UiTableConfig, context: TeamAppsUiContext);
    private isRowExpanded;
    private createSlickGrid;
    private throttledFireDisplayedRangeChanged;
    private createDisplayRangeChangedEvent;
    private toggleColumnsThatAreHiddenWhenTheyContainNoVisibleNonEmptyCells;
    private configureOuterFields;
    private getCurrentlyDisplayedRecordIds;
    doGetMainElement(): HTMLElement;
    private _createColumns;
    private createSlickColumnConfig;
    private getColumnCssClass;
    private prepareEditorField;
    private createCellFormatter;
    private getCellMessageCssClassName;
    clearTable(): void;
    updateData(startIndex: number, recordIds: number[], newRecords: UiTableClientRecordConfig[], totalNumberOfRecords: number): any;
    setSorting(sortField: string, sortDirection: UiSortDirection): void;
    setCellValue(recordId: any, fieldName: string, data: any): void;
    private rerenderRecordRow;
    private fieldMessagePopper;
    setSingleCellMessages(recordId: number, fieldName: string, messages: UiFieldMessageConfig[]): void;
    clearAllCellMessages(): void;
    private rerenderAllRows;
    setColumnMessages(fieldName: string, messages: UiFieldMessageConfig[]): void;
    private getVisibleColumns;
    private isSpecialColumn;
    private getColumnById;
    markTableField(recordId: any, fieldName: string, mark: boolean): void;
    clearAllFieldMarkings(): void;
    setRecordBold(recordId: any, bold: boolean): void;
    selectRecords(recordIds: number[], scrollToFirstIfAvailable: boolean): void;
    selectRows(rowIndexes: number[], scrollToFirst: boolean): void;
    private doWithoutFiringSelectionEvent;
    editCellIfVisible(recordId: number, row: number, propertyName: string): void;
    focusCell(recordId: any, columnPropertyName: string): void;
    onResize(): void;
    private handleFieldValueChanged;
    private getCompositeFieldColumnForSubFieldName;
    private getActiveCellValue;
    private getActiveCellRecordId;
    private getActiveCellFieldName;
    destroy(): void;
    updateRefreshableConfig(config: UiRefreshableTableConfigUpdateConfig): void;
    private updateSelectionFramePosition;
    addColumns(columnConfigs: UiTableColumnConfig[], index: number): void;
    private setSlickGridColumns;
    removeColumns(columnNames: string[]): void;
    setColumnVisibility(propertyName: string, visible: boolean): void;
    cancelEditingCell(recordId: number, propertyName: string): void;
    setContextMenuContent(requestId: number, component: UiComponent): void;
    closeContextMenu(requestId: number): void;
    setHeaderRowField(columnName: string, field: unknown): any;
    setFooterRowField(columnName: string, field: unknown): any;
}
