import { UiLineGraphDataPointConfig } from "../../generated/UiLineGraphDataPointConfig";
import { UiLineGraphDataConfig } from "../../generated/UiLineGraphDataConfig";
import { UiGraphDataConfig } from "../../generated/UiGraphDataConfig";
import { UiIncidentGraphDataConfig } from "../../generated/UiIncidentGraphDataConfig";
import { UiIncidentGraphDataPointConfig } from "../../generated/UiIncidentGraphDataPointConfig";
declare abstract class AbstractDataStore<D extends UiGraphDataConfig> {
    private intervalManagerByZoomLevel;
    private dataObsolete;
    reset(): void;
    getUncoveredIntervals(zoomLevel: number, interval: [number, number]): [number, number][];
    markIntervalAsCovered(zoomLevel: number, interval: [number, number]): void;
    addData(zoomLevel: number, data: D): void;
    protected abstract doResetData(): void;
    protected abstract doAddData(zoomLevel: number, data: D): void;
    abstract getData(zoomLevelIndex: number, intervalX: [number, number]): Omit<D, "interval">;
    private getIntervalManager;
}
export declare class LineGraphDataStore extends AbstractDataStore<UiLineGraphDataConfig> {
    private zoomLevelData;
    protected doResetData(): void;
    protected doAddData(zoomLevel: number, data: UiLineGraphDataConfig): void;
    getData(zoomLevelIndex: number, intervalX: [number, number]): {
        dataPoints: UiLineGraphDataPointConfig[];
    };
    private assureZoomLevelArrayExists;
}
export declare class IncidentGraphDataStore extends AbstractDataStore<UiIncidentGraphDataConfig> {
    private zoomLevelData;
    protected doResetData(): void;
    protected doAddData(zoomLevel: number, data: UiIncidentGraphDataConfig): void;
    getData(zoomLevelIndex: number, intervalX: [number, number]): {
        dataPoints: UiIncidentGraphDataPointConfig[];
    };
    private assureZoomLevelArrayExists;
}
export {};
