import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiFileFieldDisplayType } from "../../../generated/UiFileFieldDisplayType";
import { UiFileItemConfig } from "../../../generated/UiFileItemConfig";
export declare class UiFileItem {
    private displayMode;
    private maxBytes;
    private fileTooLargeMessage;
    private uploadErrorMessage;
    private uploadUrl;
    private config;
    state: FileItemState;
    private _deletable;
    private static LOGGER;
    readonly onClick: TeamAppsEvent<void>;
    readonly onDeleteButtonClick: TeamAppsEvent<void>;
    readonly onUploadCanceled: TeamAppsEvent<void>;
    readonly onUploadFailed: TeamAppsEvent<void>;
    readonly onUploadSuccessful: TeamAppsEvent<string>;
    readonly onUploadTooLarge: TeamAppsEvent<void>;
    private $main;
    private $progressIndicator;
    private $deleteButton;
    private $fileIcon;
    private $fileName;
    private $fileDescription;
    private $fileSize;
    private progressIndicator;
    private uploader;
    constructor(displayMode: UiFileFieldDisplayType, maxBytes: number, fileTooLargeMessage: string, uploadErrorMessage: string, uploadUrl: string, config: UiFileItemConfig, state: FileItemState, _deletable: boolean);
    upload(file: File): void;
    private static createProgressIndicator;
    setDisplayMode(displayMode: UiFileFieldDisplayType): void;
    private setState;
    getMainDomElement(): HTMLElement;
    destroy(): void;
    update(config: UiFileItemConfig): void;
    get uuid(): string;
    get icon(): string;
    get thumbnail(): string;
    get fileName(): string;
    get description(): string;
    get size(): number;
    get linkUrl(): string;
    set deletable(deletable: boolean);
}
export declare enum FileItemState {
    INITIATING = 0,
    TOO_LARGE = 1,
    UPLOADING = 2,
    FAILED = 3,
    DONE = 4
}
