export declare type Interval = [number, number];
export declare function intervalToString(interval: Interval): string;
export declare class IntervalManager {
    private log;
    private _intervals;
    addInterval(newInterval: Interval): void;
    addIntervals(intervals: Interval[]): void;
    getUncoveredIntervals(interval: Interval): Interval[];
    getCoveredIntervals(): Interval[];
    private getFirstAndLastOverlappingExistingIntervalIndex;
    static intervalsOverlap(existingInterval: Interval, interval: Interval): boolean;
    private static subtractIntervals;
    get intervals(): Interval[];
}
