import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { TabPanelItem } from "./TabPanelItem";
import { ViewInfo } from "./ViewInfo";
import { UiWindowButtonType } from "../../generated/UiWindowButtonType";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComponent } from "../UiComponent";
export declare class View implements ViewInfo {
    viewName: string;
    tabIcon: string;
    tabCaption: string;
    tabCloseable: boolean;
    lazyLoading: boolean;
    visible: boolean;
    readonly onPanelWindowButtonClicked: TeamAppsEvent<UiWindowButtonType>;
    private _parent;
    private _component;
    constructor(viewName: string, tabIcon: string, tabCaption: string, tabCloseable: boolean, lazyLoading: boolean, visible: boolean, component: UiComponent<UiComponentConfig>);
    get component(): UiComponent<UiComponentConfig>;
    set component(component: UiComponent<UiComponentConfig>);
    private handlePanelWindowButtonClicked;
    updateTabAttributes(tabIcon: string, tabCaption: string, tabCloseable: boolean, visible: boolean): void;
    setVisible(visible: boolean): any;
    get viewInfo(): ViewInfo;
    setWindowButtons(toolButtons: UiWindowButtonType[]): void;
    get parent(): TabPanelItem;
    set parent(value: TabPanelItem);
}
