import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiFloatingComponent_ExpandedOrCollapsedEvent, UiFloatingComponentCommandHandler, UiFloatingComponentConfig, UiFloatingComponentEventSource } from "../generated/UiFloatingComponentConfig";
import { UiFloatingComponentPosition } from "../generated/UiFloatingComponentPosition";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiColorConfig } from "../generated/UiColorConfig";
export declare class UiFloatingComponent extends AbstractUiComponent<UiFloatingComponentConfig> implements UiFloatingComponentCommandHandler, UiFloatingComponentEventSource {
    readonly onExpandedOrCollapsed: TeamAppsEvent<UiFloatingComponent_ExpandedOrCollapsedEvent>;
    private containerComponent;
    private contentComponent;
    private $main;
    private $expanderHandle;
    constructor(config: UiFloatingComponentConfig, context: TeamAppsUiContext);
    private updateFloatingPosition;
    getMainDomElement(): HTMLElement;
    setExpanded(expanded: boolean): void;
    setPosition(position: UiFloatingComponentPosition): void;
    setDimensions(width: number, height: number): void;
    setMargins(marginX: number, marginY: number): void;
    setBackgroundColor(backgroundColor: UiColorConfig): void;
    setExpanderHandleColor(expanderHandleColor: UiColorConfig): void;
}
