import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiFileFieldDisplayType } from "../../../generated/UiFileFieldDisplayType";
import { UiFileItemConfig } from "../../../generated/UiFileItemConfig";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
export declare class UiFileItem {
    private displayMode;
    private maxBytes;
    private fileTooLargeMessage;
    private uploadErrorMessage;
    private uploadUrl;
    private config;
    state: FileItemState;
    private context;
    private static LOGGER;
    readonly onClick: TeamAppsEvent<void>;
    readonly onDeleteButtonClick: TeamAppsEvent<void>;
    readonly onUploadCanceled: TeamAppsEvent<void>;
    readonly onUploadFailed: TeamAppsEvent<void>;
    readonly onUploadSuccessful: TeamAppsEvent<string>;
    readonly onUploadTooLarge: TeamAppsEvent<void>;
    private $main;
    private $progressIndicator;
    private $deleteButton;
    private $fileIcon;
    private $fileName;
    private $fileDescription;
    private $fileSize;
    private progressIndicator;
    private uploader;
    constructor(displayMode: UiFileFieldDisplayType, maxBytes: number, fileTooLargeMessage: string, uploadErrorMessage: string, uploadUrl: string, config: UiFileItemConfig, state: FileItemState, context: TeamAppsUiContext);
    upload(file: File): void;
    private static createProgressIndicator;
    setDisplayMode(displayMode: UiFileFieldDisplayType): void;
    private setState;
    getMainDomElement(): HTMLElement;
    destroy(): void;
    update(config: UiFileItemConfig): void;
    readonly uuid: string;
    readonly icon: string;
    readonly thumbnail: string;
    readonly fileName: string;
    readonly description: string;
    readonly size: number;
    readonly linkUrl: string;
}
export declare enum FileItemState {
    INITIATING = 0,
    TOO_LARGE = 1,
    UPLOADING = 2,
    FAILED = 3,
    DONE = 4
}
