import { UiField } from "../UiField";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiPictureChooser_UploadCanceledEvent, UiPictureChooser_UploadFailedEvent, UiPictureChooser_UploadInitiatedByUserEvent, UiPictureChooser_UploadStartedEvent, UiPictureChooser_UploadSuccessfulEvent, UiPictureChooser_UploadTooLargeEvent, UiPictureChooserCommandHandler, UiPictureChooserConfig, UiPictureChooserEventSource } from "../../../generated/UiPictureChooserConfig";
/**
 * @author Yann Massard (yamass@gmail.com)
 */
export declare class UiPictureChooser extends UiField<UiPictureChooserConfig, string> implements UiPictureChooserEventSource, UiPictureChooserCommandHandler {
    readonly onUploadCanceled: TeamAppsEvent<UiPictureChooser_UploadCanceledEvent>;
    readonly onUploadFailed: TeamAppsEvent<UiPictureChooser_UploadFailedEvent>;
    readonly onUploadInitiatedByUser: TeamAppsEvent<UiPictureChooser_UploadInitiatedByUserEvent>;
    readonly onUploadStarted: TeamAppsEvent<UiPictureChooser_UploadStartedEvent>;
    readonly onUploadSuccessful: TeamAppsEvent<UiPictureChooser_UploadSuccessfulEvent>;
    readonly onUploadTooLarge: TeamAppsEvent<UiPictureChooser_UploadTooLargeEvent>;
    private $main;
    private $picture;
    private $uploadButton;
    private $fileInput;
    private $fileItemWrapper;
    private $progressWrapper;
    private $pictureWrapper;
    private $deleteButton;
    private maxFileSize;
    private fileTooLargeMessage;
    private uploadErrorMessage;
    private uploadUrl;
    private uploader;
    private progressIndicator;
    protected initialize(config: UiPictureChooserConfig, context: TeamAppsUiContext): void;
    protected displayCommittedValue(): void;
    getDefaultValue(): string;
    getFocusableElement(): HTMLElement;
    getMainInnerDomElement(): HTMLElement;
    getTransientValue(): string;
    isValidData(v: string): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode, oldEditingMode?: UiFieldEditingMode): void;
    valuesChanged(v1: string, v2: string): boolean;
    setBrowseButtonIcon(browseButtonIcon: string): void;
    setFileTooLargeMessage(fileTooLargeMessage: string): void;
    setMaxFileSize(maxFileSize: number): void;
    setUploadErrorMessage(uploadErrorMessage: string): void;
    setUploadUrl(uploadUrl: string): void;
    private updateVisibilities;
    private handleFiles;
    private setImageDisplaySize;
}
export declare function formatString(s: string, ...params: any[]): string;
