/// <reference types="slickgrid" />
import { UiHierarchicalClientRecordConfig } from "../../generated/UiHierarchicalClientRecordConfig";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
import { UiTableClientRecordConfig } from "../../generated/UiTableClientRecordConfig";
export interface TableDataProviderItem extends UiTableClientRecordConfig {
    children: TableDataProviderItem[];
    depth: number;
    parentId: number;
    expanded: boolean;
}
export declare class TableDataProvider {
    private dataRequestCallback;
    onDataLoading: Slick.Event<unknown>;
    private static LOOKAHAED;
    private timerId;
    private data;
    private numberOfRootNodes;
    constructor(data: UiHierarchicalClientRecordConfig[], dataRequestCallback: Function);
    private prepareData;
    private isRowExpanded;
    toggleRowExpanded(rowIndex: number): void;
    private getListOfVisibleDescendants;
    /**
     * @param parentItemRowIndex
     * @returns {number} the index of the first non-child row following the node specified by parentItemRowIndex
     */
    private findEndOfChildrenIndex;
    /**
     * This method is called by SlickGrid.
     */
    getLength(): number;
    setTotalNumberOfRootNodes(totalNumberOfRootNodes: number): void;
    getTotalNumberOfRootNodes(): number;
    /**
     * This method is called by SlickGrid.
     */
    getItem(index: number): TableDataProviderItem;
    /**
     * This method is called by SlickGrid.
     */
    getItemMetadata(index: number): Slick.RowMetadata<any>;
    clear(): void;
    updateRootNodeData(startRootNodeIndex: number, newData: any[]): void;
    setChildrenData(parentRecordId: number, tableData: any[]): void;
    removeItem(recordId: number): void;
    removeItems(recordIds: number[]): void;
    deleteItems(recordIds: number[]): void;
    private removeItemInternal;
    ensureData(firstVisibleRowIndex: number, lastVisibleRowIndex: number): void;
    findVisibleRowIndexById(id: number): number;
    findVisibleRowIndexesByIds(ids: number[]): {
        [id: number]: number;
    };
    getNodeById(id: number): TableDataProviderItem;
    private findNodes;
    setCellMarked(recordId: number, propertyName: string, marked: boolean): void;
    clearAllFieldMarkings(): void;
    setCellMessages(recordId: number, fieldName: string, messages: UiFieldMessageConfig[]): void;
    clearAllCellMessages(): void;
    insertRows(index: number, data: UiTableClientRecordConfig[]): void;
    updateNode(record: UiTableClientRecordConfig): void;
}
