/// <reference path="../../../ts/custom-declarations/d3v3.d.ts" />
import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiNetworkGraph_NodeClickedEvent, UiNetworkGraph_NodeDoubleClickedEvent, UiNetworkGraph_NodeExpandedOrCollapsedEvent, UiNetworkGraphCommandHandler, UiNetworkGraphConfig, UiNetworkGraphEventSource } from "../generated/UiNetworkGraphConfig";
import { UiNetworkNodeConfig } from "../generated/UiNetworkNodeConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiNetworkLinkConfig } from "../generated/UiNetworkLinkConfig";
export declare class UiNetworkGraph extends AbstractUiComponent<UiNetworkGraphConfig> implements UiNetworkGraphCommandHandler, UiNetworkGraphEventSource {
    readonly onNodeClicked: TeamAppsEvent<UiNetworkGraph_NodeClickedEvent>;
    readonly onNodeDoubleClicked: TeamAppsEvent<UiNetworkGraph_NodeDoubleClickedEvent>;
    readonly onNodeExpandedOrCollapsed: TeamAppsEvent<UiNetworkGraph_NodeExpandedOrCollapsedEvent>;
    private $graph;
    private svg;
    private pointerEventsRect;
    private container;
    private linksContainer;
    private zoom;
    private simulation;
    private linkForce;
    private nodes;
    private links;
    constructor(config: UiNetworkGraphConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    createGraph(gravity: any, images: any): void;
    private calculateFinalNodePositions;
    zoomAllNodesIntoView(animationDuration: number): void;
    onResize(): void;
    setZoomFactor(zoomFactor: number): void;
    setGravity(gravity: number): void;
    setDistance(linkDistance: number, nodeDistance: number): void;
    setCharge(charge: number, overrideNodeCharge: boolean): void;
    private updateLinks;
    private updateNodes;
    restyleForeignObjectElements(): void;
    addNodesAndLinks(newNodes: UiNetworkNodeConfig[], newLinks: UiNetworkLinkConfig[]): void;
    private placeNewNodesNearExistingParentsOnes;
    removeNodesAndLinks(nodeIds: string[], linksBySourceNodeId: {
        [name: string]: string[];
    }): void;
}
