import { ScaleContinuousNumeric, ScaleTime } from "d3-scale";
import { SVGGSelection } from "./Charting";
import { AbstractUiLineChartDataDisplayConfig } from "../../generated/AbstractUiLineChartDataDisplayConfig";
import { TimeGraphDataStore } from "./TimeGraphDataStore";
export declare abstract class AbstractUiLineChartDataDisplay<C extends AbstractUiLineChartDataDisplayConfig = AbstractUiLineChartDataDisplayConfig> {
    protected config: C;
    protected timeGraphId: string;
    protected dataStore: TimeGraphDataStore;
    scaleY: ScaleContinuousNumeric<number, number>;
    $yAxis: SVGGSelection;
    private yAxis;
    constructor(config: C, timeGraphId: string, dataStore: TimeGraphDataStore);
    protected zoomLevelIndex: number;
    protected scaleX: ScaleTime<number, number>;
    abstract get yScaleWidth(): number;
    updateZoomX(zoomLevelIndex: number, scaleX: ScaleTime<number, number>): void;
    redraw(): void;
    private getYAxisRange;
    private updateYScale;
    setScaleYRange(range: [number, number]): void;
    protected abstract doRedraw(): void;
    updateYAxisTickFormat(): void;
    private redrawYAxis;
    setConfig(config: C): void;
    protected getDisplayedData(): {
        [dataSeriesId: string]: import("./Charting").DataPoint[];
    };
    abstract getDataSeriesIds(): string[];
    abstract destroy(): void;
    getDisplayedDataYBounds(): [number, number];
    getConfig(): C;
}
