import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
import { UiButton_ClickedEvent, UiButton_DropDownOpenedEvent, UiButtonCommandHandler, UiButtonConfig, UiButtonEventSource } from "../../generated/UiButtonConfig";
import { UiField } from "./UiField";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
import { UiComponent } from "../UiComponent";
export declare class UiButton extends UiField<UiButtonConfig, void> implements UiButtonEventSource, UiButtonCommandHandler {
    readonly onClicked: TeamAppsEvent<UiButton_ClickedEvent>;
    readonly onDropDownOpened: TeamAppsEvent<UiButton_DropDownOpenedEvent>;
    private template;
    private templateRecord;
    private $main;
    private _dropDown;
    private dropDownComponent;
    private minDropDownWidth;
    private minDropDownHeight;
    private openDropDownIfNotSet;
    protected initialize(config: UiButtonConfig, context: TeamAppsUiContext): void;
    setDropDownSize(minDropDownWidth: number, minDropDownHeight: number): void;
    setDropDownComponent(component: UiComponent): void;
    private closeDropDown;
    private get dropDown();
    setOpenDropDownIfNotSet(openDropDownIfNotSet: boolean): void;
    getMainInnerDomElement(): HTMLElement;
    setTemplate(template: UiTemplateConfig, templateRecord: any): void;
    setTemplateRecord(data: any): void;
    private renderContent;
    setFieldMessages(fieldMessageConfigs: UiFieldMessageConfig[]): void;
    getFocusableElement(): HTMLElement;
    focus(): void;
    protected displayCommittedValue(): void;
    getTransientValue(): true;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: void, availableWidth: number): string;
    valuesChanged(v1: void, v2: void): boolean;
    isValidData(v: void): boolean;
    getDefaultValue(): true;
}
